/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleControlClientScreenModule;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleControlScreenModule;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleStatusScreenModule;
import mcjty.rftoolsbuilder.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VehicleStatusModuleItem
extends GenericModuleItem
implements IComponentsToPreserve {
    protected int getUses(ItemStack stack) {
        return (Integer)MoverConfiguration.VEHICLE_STATUS_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)VehicleStatusModuleItem.data(stack).getPos().pos());
    }

    protected String getInfoString(ItemStack stack) {
        VehicleStatusScreenModule data = VehicleStatusModuleItem.data(stack);
        return ModuleTools.getTargetString((String)data.getMonitor(), (GlobalPos)data.getPos());
    }

    public VehicleStatusModuleItem() {
        super(Registration.createStandardProperties().stacksTo(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return VehicleStatusScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return VehicleStatusScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)MoverModule.MODULE_VEHICLESTATUS_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return VehicleControlScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new VehicleControlClientScreenModule();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof MoverControllerTileEntity) {
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            String name = "<invalid>";
            if (block != null && !world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Vehicle control module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Vehicle control module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public String getModuleName() {
        return "VStat";
    }

    public static VehicleStatusScreenModule data(ItemStack stack) {
        VehicleStatusScreenModule data = (VehicleStatusScreenModule)stack.get(MoverModule.MODULE_VEHICLESTATUS_DATA);
        if (data == null) {
            data = VehicleStatusScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Consumer<VehicleStatusScreenModule> setter) {
        VehicleStatusScreenModule data = VehicleStatusModuleItem.data(stack);
        setter.accept(data);
        stack.set(MoverModule.MODULE_VEHICLESTATUS_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text((stack, s) -> VehicleStatusModuleItem.data(stack).withLabel((String)s), stack -> VehicleStatusModuleItem.data(stack).getLabel(), new String[]{"Label text"}).color((stack, c) -> VehicleStatusModuleItem.data(stack).withLabelColor((int)c), stack -> VehicleStatusModuleItem.data(stack).getLabelColor(), new String[]{"Label color"}).nl().label("Vehicle:").text((stack, s) -> VehicleStatusModuleItem.data(stack).withVehicle((String)s), stack -> VehicleStatusModuleItem.data(stack).getVehicle(), new String[]{"Name of the vehicle"}).color((stack, c) -> VehicleStatusModuleItem.data(stack).withColor((int)c), stack -> VehicleStatusModuleItem.data(stack).getColor(), new String[]{"Mover color"}).nl().choices((stack, c) -> VehicleStatusModuleItem.data(stack, d -> d.withAlign(TextAlign.get((String)c))), stack -> VehicleStatusModuleItem.data(stack).getAlign().getSerializedName(), "Label alignment", new String[]{"Left", "Center", "Right"}).nl();
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)MoverModule.MODULE_VEHICLESTATUS_DATA.get());
    }
}

