/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class GuiChamberDetails
extends GuiItemScreen {
    private static final int CHAMBER_XSIZE = 390;
    private static final int CHAMBER_YSIZE = 210;
    private static Map<BlockState, Integer> items = null;
    private static Map<BlockState, Integer> costs = null;
    private static Map<BlockState, ItemStack> stacks = null;
    private static Map<String, Integer> entities = null;
    private static Map<String, Integer> entityCosts = null;
    private static Map<String, CompoundTag> realEntities = null;
    private static Map<String, String> playerNames = null;
    private WidgetList blockList;
    private Label infoLabel;
    private Label info2Label;

    public GuiChamberDetails() {
        super(390, 210, ManualEntry.EMPTY);
        this.requestChamberInfoFromServer();
    }

    public static void setItemsWithCount(Map<BlockState, Integer> items, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, CompoundTag> realEntities, Map<String, String> playerNames) {
        GuiChamberDetails.items = new HashMap<BlockState, Integer>(items);
        GuiChamberDetails.costs = new HashMap<BlockState, Integer>(costs);
        GuiChamberDetails.stacks = new HashMap<BlockState, ItemStack>(stacks);
        GuiChamberDetails.entities = new HashMap<String, Integer>(entities);
        GuiChamberDetails.entityCosts = new HashMap<String, Integer>(entityCosts);
        GuiChamberDetails.realEntities = new HashMap<String, CompoundTag>(realEntities);
        GuiChamberDetails.playerNames = new HashMap<String, String>(playerNames);
    }

    private void requestChamberInfoFromServer() {
        RFToolsBuilderMessages.sendToServer("getChamberInfo");
    }

    public void init() {
        super.init();
        this.blockList = (WidgetList)new WidgetList().name("blocks");
        Slider listSlider = ((Slider)new Slider().desiredWidth(10)).vertical().scrollableName("blocks");
        Panel listPanel = (Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.blockList, listSlider});
        this.infoLabel = (Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.infoLabel.desiredWidth(380)).desiredHeight(14);
        this.info2Label = (Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.info2Label.desiredWidth(380)).desiredHeight(14);
        Panel toplevel = (Panel)((Panel)Widgets.vertical((int)3, (int)1).filledRectThickness(2)).children(new Widget[]{listPanel, this.infoLabel, this.info2Label});
        toplevel.bounds(this.guiLeft, this.guiTop, this.xSize, this.ySize);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void populateLists() {
        this.blockList.removeChildren();
        if (items == null) {
            return;
        }
        int totalCost = 0;
        for (Map.Entry<BlockState, Integer> entry : items.entrySet()) {
            ItemStack stack;
            BlockState bm = entry.getKey();
            int count = entry.getValue();
            int cost = costs.get(bm);
            Panel panel = (Panel)Widgets.horizontal().desiredHeight(16);
            if (stacks.containsKey(bm)) {
                stack = stacks.get(bm);
            } else {
                stack = bm.getBlock().getCloneItemStack((LevelReader)Minecraft.getInstance().level, BlockPos.ZERO, bm);
                if (stack.isEmpty()) {
                    stack = new ItemStack((ItemLike)bm.getBlock(), 0);
                }
            }
            BlockRender blockRender = new BlockRender().renderItem((Object)stack).offsetX(-1).offsetY(-1);
            Label nameLabel = (Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).color(StyleConfig.colorTextInListNormal);
            stack.getItem();
            ((Label)nameLabel.text(stack.getHoverName().getString())).desiredWidth(160);
            Label countLabel = (Label)Widgets.label((String)String.valueOf(count)).color(StyleConfig.colorTextInListNormal);
            ((Label)countLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(50);
            Label costLabel = (Label)new Label().color(StyleConfig.colorTextInListNormal);
            costLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.text("NOT MOVABLE!");
            } else {
                costLabel.text("Move Cost " + cost + " RF");
                totalCost += cost;
            }
            panel.children(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.children(new Widget[]{panel});
        }
        int totalCostEntities = 0;
        RenderHelper.rot += 0.5f;
        for (Map.Entry<String, Integer> entry : entities.entrySet()) {
            String id = entry.getKey();
            int count = entry.getValue();
            int cost = entityCosts.get(id);
            Panel panel = (Panel)Widgets.horizontal().desiredHeight(16);
            Object entityName = "<?>";
            Entity entity = null;
            if (realEntities.containsKey(id)) {
                ItemEntity entityItem;
                CompoundTag tag = realEntities.get(id);
                EntityType value = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
                entity = value.create((Level)this.minecraft.level);
                entity.load(tag);
                entityName = entity.getDisplayName().getString();
                if (entity instanceof ItemEntity && !(entityItem = (ItemEntity)entity).getItem().isEmpty()) {
                    String displayName = entityItem.getItem().getDisplayName().getString();
                    entityName = (String)entityName + " (" + displayName + ")";
                }
            } else {
                EntityType value = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
                entity = value.create((Level)this.minecraft.level);
                entityName = entity.getDisplayName().getString();
            }
            if (playerNames.containsKey(id)) {
                entityName = playerNames.get(id);
            }
            BlockRender blockRender = new BlockRender().renderItem((Object)entity).offsetX(-1).offsetY(-1);
            Label nameLabel = (Label)((Label)Widgets.label((String)entityName).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(160);
            Label countLabel = Widgets.label((String)String.valueOf(count));
            ((Label)countLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(50);
            Label costLabel = new Label();
            costLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.text("NOT MOVABLE!");
            } else {
                costLabel.text("Move Cost " + cost + " RF");
                totalCostEntities += cost;
            }
            panel.children(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.children(new Widget[]{panel});
        }
        this.infoLabel.text("Total cost blocks: " + totalCost + " RF");
        this.info2Label.text("Total cost entities: " + totalCostEntities + " RF");
    }

    protected void renderInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float partialTick) {
        this.populateLists();
        this.drawWindow(graphics, pMouseX, pMouseY, partialTick);
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new GuiChamberDetails());
    }
}

