/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gems.block.teleporter.AbstractTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.TeleporterBlockEntity;
import net.silentchaos512.gems.setup.GemsDataComponents;
import net.silentchaos512.lib.util.DimPos;

public class TeleporterLinker
extends Item {
    public TeleporterLinker(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (!(state.getBlock() instanceof AbstractTeleporterBlock)) {
            return super.useOn(context);
        }
        ItemStack stack = context.getItemInHand();
        DimPos clickedDimPos = DimPos.of((BlockPos)context.getClickedPos(), (ResourceKey)context.getLevel().dimension());
        Player player = context.getPlayer();
        if (stack.has(GemsDataComponents.LINKED_POS)) {
            DimPos storedDimPos = (DimPos)stack.get(GemsDataComponents.LINKED_POS);
            assert (storedDimPos != null);
            if (player != null) {
                this.tryLinkTeleporter(player, storedDimPos, clickedDimPos.offset(Direction.UP, 1));
                this.tryLinkTeleporter(player, clickedDimPos, storedDimPos.offset(Direction.UP, 1));
                stack.remove(GemsDataComponents.LINKED_POS);
                player.displayClientMessage((Component)Component.literal((String)"Teleporters linked!"), true);
            }
        } else {
            stack.set(GemsDataComponents.LINKED_POS, (Object)clickedDimPos);
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)"Teleporter position stored!"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void tryLinkTeleporter(Player player, DimPos teleporterPosition, DimPos newDestination) {
        Optional level = teleporterPosition.getPosLevel(player.level());
        if (level.isPresent()) {
            BlockEntity blockEntity = ((Level)level.get()).getBlockEntity(teleporterPosition.getPos());
            if (blockEntity instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity teleporterBlockEntity = (TeleporterBlockEntity)blockEntity;
                teleporterBlockEntity.setDestination(newDestination);
            }
        } else if (!player.level().isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)("Could not link teleporter at " + String.valueOf(teleporterPosition))), false);
        }
    }
}

