/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.GemOreBlock;
import net.silentchaos512.gems.data.GemsBlockTagsProvider;
import net.silentchaos512.gems.data.GemsDamageTypeTagsProvider;
import net.silentchaos512.gems.data.GemsEntityTypeTagsProvider;
import net.silentchaos512.gems.data.GemsItemTagsProvider;
import net.silentchaos512.gems.data.GemsLootTableProvider;
import net.silentchaos512.gems.data.GemsMaterialsProvider;
import net.silentchaos512.gems.data.GemsTraitsProvider;
import net.silentchaos512.gems.data.WorldGenGenerator;
import net.silentchaos512.gems.data.client.GemsBlockStateProvider;
import net.silentchaos512.gems.data.client.GemsItemModelProvider;
import net.silentchaos512.gems.data.recipe.GemsRecipeProvider;
import net.silentchaos512.gems.setup.GemsBlocks;

@EventBusSubscriber(modid="silentgems", bus=EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        GemsBlockTagsProvider blockTags = new GemsBlockTagsProvider(event);
        generator.addProvider(true, (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new GemsItemTagsProvider(event, blockTags));
        generator.addProvider(true, (DataProvider)new GemsEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new GemsDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(true, (DataProvider)new GemsRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new GemsLootTableProvider(packOutput, lookupProvider));
        boolean gearIsLoaded = ModList.get().isLoaded("silentgear");
        if (gearIsLoaded) {
            generator.addProvider(true, (DataProvider)new GemsTraitsProvider(generator));
            generator.addProvider(true, (DataProvider)new GemsMaterialsProvider(generator));
        }
        generator.addProvider(true, (DataProvider)new GemsBlockStateProvider(generator, existingFileHelper));
        generator.addProvider(true, (DataProvider)new GemsItemModelProvider(generator, existingFileHelper));
        generator.addProvider(true, (DataProvider)new WorldGenGenerator(event));
        SilentGems.LOGGER.info(GemsBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block instanceof GemOreBlock).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).map(ResourceLocation::toString).collect(Collectors.joining(" ")));
    }
}

