/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gems.setup.GemsBlockEntityTypes;
import net.silentchaos512.lib.util.DimPos;

public class TeleporterBlockEntity
extends BlockEntity {
    public static final String DESTINATION_TAG = "Destination";
    private DimPos destination = null;

    public TeleporterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public TeleporterBlockEntity(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)GemsBlockEntityTypes.TELEPORTER.get(), pos, blockState);
    }

    @Nullable
    public DimPos getDestination() {
        return this.destination;
    }

    public void setDestination(DimPos newDestination) {
        this.destination = newDestination;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.destination != null) {
            tag.put(DESTINATION_TAG, (Tag)this.destination.serializeNbt());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(DESTINATION_TAG, 10)) {
            this.destination = DimPos.deserializeNbt((CompoundTag)tag.getCompound(DESTINATION_TAG));
        }
    }
}

