/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.silentchaos512.gems.GemsConfig;
import net.silentchaos512.gems.block.IGemBlock;
import net.silentchaos512.gems.util.Gems;

public class GlowroseBlock
extends FlowerBlock
implements IGemBlock {
    private final Gems gem;

    public GlowroseBlock(Gems gem, BlockBehaviour.Properties properties) {
        super(GlowroseBlock.makeEffectList((Holder)MobEffects.GLOWING, (float)8.0f), properties);
        this.gem = gem;
    }

    @Override
    public Gems getGem() {
        return this.gem;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return super.mayPlaceOn(state, worldIn, pos) || state.is(BlockTags.BASE_STONE_NETHER) || state.getBlock() == Blocks.NETHER_QUARTZ_ORE || state.is(BlockTags.NYLIUM) || state.is(Tags.Blocks.END_STONES);
    }

    public MutableComponent getName() {
        return this.getGemBlockName();
    }

    @Override
    public MutableComponent getGemBlockName() {
        return Component.translatable((String)"block.silentgems.glowrose", (Object[])new Object[]{this.gem.getDisplayName()});
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)GemsConfig.COMMON.glowroseNormalLight.get();
    }
}

