/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Borders;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class InfoPanel
extends GuiElement<InfoPanel> {
    private static AtomicBoolean globalExpanded = new AtomicBoolean(false);
    private AtomicBoolean expanded = globalExpanded;
    private double animState = 0.0;
    private List<GuiElement<?>> items = new ArrayList();
    private GuiElement<?> lastItem;
    private GuiElement<?> initialItem;
    private Borders borders = Borders.create((double)4.0, (double)3.0);
    private double maxWidth = 200.0;

    protected InfoPanel(@NotNull GuiParent<?> parent) {
        super(parent);
        this.jeiExclude();
        this.setInfoPos(InfoPos.RIGHT_TOP, 2);
        this.animState = this.expanded() ? 1.0 : 0.0;
        this.setEnabled(() -> this.expanded() || this.animState > 0.0);
        this.initialItem = this.lastItem = new GuiElement((GuiParent)this);
        Constraints.size(this.lastItem, (double)0.0, (double)0.0);
        this.lastItem.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), () -> this.borders.top));
        this.lastItem.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), () -> this.borders.left));
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (this.items.stream().mapToDouble(ConstrainedGeometry::xSize).max().orElse(0.0) + this.borders.left + this.borders.right) * this.animState));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> (this.items.stream().mapToDouble(ConstrainedGeometry::ySize).sum() + this.borders.top + this.borders.bottom) * this.animState));
    }

    public static InfoPanel create(GuiElement<?> parent) {
        return InfoPanel.create(parent, e -> InfoPanel.background(e, 0x100010, 33023));
    }

    public static InfoPanel create(GuiElement<?> parent, Function<InfoPanel, GuiElement<?>> backgroundFunc) {
        InfoPanel panel = new InfoPanel((GuiParent<?>)parent);
        GuiElement<?> bg = backgroundFunc.apply(panel);
        Constraints.bind(bg, (ConstrainedGeometry)panel);
        return panel;
    }

    public InfoPanel setExpandedStateHolder(AtomicBoolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public double getFadeAlpha() {
        return this.animState;
    }

    public boolean expanded() {
        return this.expanded.get();
    }

    public boolean fullExpansion() {
        return this.expanded() && this.animState >= 1.0;
    }

    public void toggleExpanded() {
        this.expanded.set(!this.expanded.get());
    }

    public InfoPanel setInfoPos(InfoPos pos, int offset) {
        ((InfoPanel)((InfoPanel)((InfoPanel)this.constrain(GeoParam.TOP, null)).constrain(GeoParam.LEFT, null)).constrain(GeoParam.BOTTOM, null)).constrain(GeoParam.RIGHT, null);
        GuiElement root = this.getModularGui().getRoot();
        return switch (pos.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (InfoPanel)((InfoPanel)this.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)offset));
            case 1 -> (InfoPanel)((InfoPanel)this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)offset));
            case 2 -> (InfoPanel)((InfoPanel)this.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)offset));
            case 3 -> (InfoPanel)((InfoPanel)this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)offset));
        };
    }

    public InfoPanel setBorders(Borders borders) {
        this.borders = borders;
        return this;
    }

    public InfoPanel setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if (this.expanded() && this.animState < 1.0) {
            this.animState = Math.min(1.0, this.animState + 0.1);
        } else if (!this.expanded() && this.animState > 0.0) {
            this.animState = Math.max(0.0, this.animState - 0.1);
        }
    }

    public InfoPanel labeledValue(Component labelComp, Supplier<Component> valueSupply) {
        return this.labeledValue(labelComp, 6, 2, valueSupply);
    }

    public InfoPanel labeledValue(Component labelComp, int valueOffset, int separation, Supplier<Component> valueSupply) {
        GuiElement container = new GuiElement((GuiParent)this);
        container.setEnabled(this::fullExpansion);
        GuiText label = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container, labelComp).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.min((double)this.font().width((FormattedText)labelComp), this.maxWidth)))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        GuiText value = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container, valueSupply).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)label.get(GeoParam.BOTTOM), (double)separation))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.LEFT), (double)valueOffset))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.min((double)this.font().width((FormattedText)valueSupply.get()), this.maxWidth)))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        container.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.max(label.xSize(), value.xSize() + (double)valueOffset)));
        container.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> label.ySize() + (double)separation + value.ySize() + 1.0));
        this.items.add(container);
        container.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.lastItem.get(GeoParam.BOTTOM), (double)0.0));
        container.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.lastItem.get(GeoParam.LEFT), (double)0.0));
        this.lastItem = container;
        return this;
    }

    public InfoPanel label(Component labelComp) {
        GuiElement container = new GuiElement((GuiParent)this);
        container.setEnabled(this::fullExpansion);
        GuiText label = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container, labelComp).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.min((double)this.font().width((FormattedText)labelComp), this.maxWidth)))).setAlignment(Align.LEFT).setWrap(true).autoHeight();
        container.constrain(GeoParam.WIDTH, (Constraint)Constraint.match((GeoRef)label.get(GeoParam.WIDTH)));
        container.constrain(GeoParam.HEIGHT, (Constraint)Constraint.relative((GeoRef)label.get(GeoParam.HEIGHT), (double)2.0));
        this.items.add(container);
        container.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.lastItem.get(GeoParam.BOTTOM), (double)0.0));
        container.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.lastItem.get(GeoParam.LEFT), (double)0.0));
        this.lastItem = container;
        return this;
    }

    public void clear() {
        this.removeChild(this.initialItem);
        this.items.forEach(arg_0 -> ((InfoPanel)this).removeChild(arg_0));
        this.items.clear();
        this.initialItem = this.lastItem = new GuiElement((GuiParent)this);
        Constraints.size(this.lastItem, (double)0.0, (double)0.0);
        this.lastItem.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), () -> this.borders.top));
        this.lastItem.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), () -> this.borders.left));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver()) {
            this.toggleExpanded();
            this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    public static GuiRectangle background(final InfoPanel panel, final int background, final int border) {
        return new GuiRectangle((GuiParent)panel){

            public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                int bgColour = background | (int)(240.0 * panel.getFadeAlpha()) << 24;
                int borderColour = border | (int)(176.0 * panel.getFadeAlpha()) << 24;
                int borderColourEnd = (borderColour & 0xFEFEFE) >> 1 | borderColour & 0xFF000000;
                render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), bgColour, borderColour, borderColourEnd);
            }
        };
    }

    public static enum InfoPos {
        RIGHT_TOP,
        RIGHT_BOTTOM,
        LEFT_TOP,
        LEFT_BOTTOM;

    }
}

