/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class MultiCapabilityProvider
implements INBTSerializable<CompoundTag> {
    private Map<ItemCapability<?, Void>, Object> capabilityMap = new HashMap();
    private Map<String, INBTSerializable<CompoundTag>> nameMap = new HashMap<String, INBTSerializable<CompoundTag>>();

    public MultiCapabilityProvider() {
    }

    public MultiCapabilityProvider(INBTSerializable<CompoundTag> capInstance, String name, ItemCapability<?, Void> ... capabilities) {
        this.addCapability(capInstance, name, capabilities);
    }

    public void addCapability(INBTSerializable<CompoundTag> capInstance, String name, ItemCapability<?, Void> ... capabilities) {
        this.nameMap.put(name, capInstance);
        for (ItemCapability<?, Void> cap : capabilities) {
            Objects.requireNonNull(cap);
            this.capabilityMap.put(cap, capInstance);
        }
    }

    public <T> void addUnsavedCap(ItemCapability<T, Void> capability, T capInstance) {
        this.capabilityMap.put(capability, capInstance);
    }

    @Nullable
    public <T> T getCapability(ItemCapability<T, Void> cap, @Nullable Direction side) {
        if (this.capabilityMap.containsKey(cap)) {
            return (T)this.capabilityMap.get(cap);
        }
        return null;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.nameMap.forEach((s, t) -> tag.put(s, t.serializeNBT(provider)));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.nameMap.forEach((s, t) -> t.deserializeNBT(provider, (Tag)nbt.getCompound(s)));
    }
}

