/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.power;

import com.brandon3055.brandonscore.api.power.IOInfo;
import net.neoforged.fml.util.thread.EffectiveSide;

public class IOTracker
implements IOInfo,
Runnable {
    protected long[] inputArray;
    protected long[] outputArray;
    protected long inputPerTick = 0L;
    protected long outputPerTick = 0L;
    protected int tick;
    protected int lastInputCheck = 0;
    protected int lastOutputCheck = 0;

    public IOTracker(int averageTime) {
        this.inputArray = new long[averageTime];
        this.outputArray = new long[averageTime];
    }

    public IOTracker() {
        this(20);
    }

    @Override
    public void run() {
        ++this.tick;
        this.inputArray[this.tick % this.inputArray.length] = 0L;
        this.outputArray[this.tick % this.outputArray.length] = 0L;
    }

    public void energyInserted(long amount) {
        int i = this.tick % this.inputArray.length;
        if (this.inputArray[i] == 0L) {
            int n = i;
            this.inputArray[n] = this.inputArray[n] + amount;
        } else {
            long space = Long.MAX_VALUE - this.inputArray[i];
            int n = i;
            this.inputArray[n] = this.inputArray[n] + Math.min(space, amount);
        }
    }

    public void energyExtracted(long amount) {
        int i = this.tick % this.inputArray.length;
        if (this.outputArray[i] == 0L) {
            int n = i;
            this.outputArray[n] = this.outputArray[n] + amount;
        } else {
            long space = Long.MAX_VALUE - this.outputArray[i];
            int n = i;
            this.outputArray[n] = this.outputArray[n] + Math.min(space, amount);
        }
    }

    public void energyModified(long amount) {
        if (amount > 0L) {
            this.energyInserted(amount);
        } else {
            this.energyExtracted(amount * -1L);
        }
    }

    public void syncClientValues(long inputPerTick, long outputPerTick) {
        this.inputPerTick = inputPerTick;
        this.outputPerTick = outputPerTick;
    }

    @Override
    public long currentInput() {
        if (EffectiveSide.get().isClient()) {
            return this.inputPerTick;
        }
        if (this.tick != this.lastInputCheck) {
            this.lastInputCheck = this.tick;
            this.inputPerTick = IOTracker.averageLongArray(this.inputArray, this.tick % this.inputArray.length);
        }
        return this.inputPerTick;
    }

    @Override
    public long currentOutput() {
        if (EffectiveSide.get().isClient()) {
            return this.outputPerTick;
        }
        if (this.tick != this.lastOutputCheck) {
            this.lastOutputCheck = this.tick;
            this.outputPerTick = IOTracker.averageLongArray(this.outputArray, this.tick % this.inputArray.length);
        }
        return this.outputPerTick;
    }

    public static long averageLongArray(long[] array, int skipIndex) {
        long average = 0L;
        double remainder = 0.0;
        int count = array.length - 1;
        for (int i = 0; i < array.length; ++i) {
            if (i == skipIndex) continue;
            long val = array[i];
            average += val / (long)count;
            remainder += (double)val % (double)count / (double)count;
        }
        return average + Math.round(remainder + (double)0.1f);
    }
}

