/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import mekanism.common.Mekanism;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import org.jetbrains.annotations.Nullable;

public class GenHandler {
    @Nullable
    private static List<MekFeature> cachedFeatures;

    private GenHandler() {
    }

    public static void reset() {
        cachedFeatures = null;
    }

    public static boolean generate(ServerLevel world, ChunkPos chunkPos) {
        boolean generated = false;
        if (!SharedConstants.debugVoidTerrain((ChunkPos)chunkPos)) {
            List list;
            SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)world.getMinSection());
            BlockPos blockPos = sectionPos.origin();
            ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long decorationSeed = random.setDecorationSeed(world.getSeed(), blockPos.getX(), blockPos.getZ());
            int decorationStep = GenerationStep.Decoration.UNDERGROUND_ORES.ordinal() - 1;
            ToIntFunction featureIndex = decorationStep < (list = (List)chunkGenerator.featuresPerStep.get()).size() ? ((FeatureSorter.StepFeatureData)list.get(decorationStep)).indexMapping() : feature -> -1;
            List<MekFeature> features = GenHandler.getMekanismFeatures(world.registryAccess());
            for (MekFeature feature2 : features) {
                generated |= GenHandler.place((WorldGenLevel)world, chunkGenerator, blockPos, random, decorationSeed, decorationStep, featureIndex, feature2);
            }
            world.setCurrentlyGenerating(null);
        }
        return generated;
    }

    private static boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, BlockPos blockPos, WorldgenRandom random, long decorationSeed, int decorationStep, ToIntFunction<PlacedFeature> featureIndex, MekFeature feature) {
        PlacedFeature baseFeature = (PlacedFeature)feature.feature().value();
        random.setFeatureSeed(decorationSeed, featureIndex.applyAsInt(baseFeature), decorationStep);
        world.setCurrentlyGenerating(feature::retrogenKey);
        return ((PlacedFeature)feature.retrogen().value()).placeWithContext(new PlacementContext(world, chunkGenerator, Optional.of(baseFeature)), (RandomSource)random, blockPos);
    }

    private static List<MekFeature> getMekanismFeatures(RegistryAccess registryAccess) {
        if (cachedFeatures != null) {
            return cachedFeatures;
        }
        cachedFeatures = new ArrayList<MekFeature>();
        Registry placedFeatures = registryAccess.registryOrThrow(Registries.PLACED_FEATURE);
        for (OreType type : EnumUtils.ORE_TYPES) {
            int features = type.getBaseConfigs().size();
            for (int vein = 0; vein < features; ++vein) {
                OreType.OreVeinType oreVeinType = new OreType.OreVeinType(type, vein);
                MekFeature mekFeature = MekFeature.create((Registry<PlacedFeature>)placedFeatures, Mekanism.rl(oreVeinType.name()));
                if (mekFeature == null) continue;
                cachedFeatures.add(mekFeature);
            }
        }
        MekFeature saltFeature = MekFeature.create((Registry<PlacedFeature>)placedFeatures, Mekanism.rl("salt"));
        if (saltFeature != null) {
            cachedFeatures.add(saltFeature);
        }
        return cachedFeatures;
    }

    private record MekFeature(Holder<PlacedFeature> feature, Holder<PlacedFeature> retrogen, String retrogenKey) {
        @Nullable
        public static MekFeature create(Registry<PlacedFeature> placedFeatures, ResourceLocation name) {
            Optional placedFeature = placedFeatures.getHolder(ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)name));
            if (placedFeature.isEmpty()) {
                Mekanism.logger.error("Failed to retrieve placed feature ({}).", (Object)name);
                return null;
            }
            ResourceLocation retrogenName = name.withSuffix("_retrogen");
            ResourceKey retrogenKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)retrogenName);
            Optional retrogenFeature = placedFeatures.getHolder(retrogenKey);
            if (retrogenFeature.isEmpty()) {
                Mekanism.logger.error("Failed to retrieve retrogen placed feature ({}).", (Object)retrogenName);
                return null;
            }
            return new MekFeature((Holder<PlacedFeature>)((Holder)placedFeature.get()), (Holder<PlacedFeature>)((Holder)retrogenFeature.get()), retrogenKey.toString());
        }
    }
}

