/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.common.Mekanism;
import mekanism.common.lib.multiblock.IInternalMultiblock;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, @NotNull BlockPos pos) {
        return WorldUtils.isChunkLoaded(world, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, long pos) {
        return WorldUtils.isChunkLoaded(world, SectionPos.blockToSectionCoord((int)BlockPos.getX((long)pos)), SectionPos.blockToSectionCoord((int)BlockPos.getZ((long)pos)));
    }

    @Contract(value="null, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, ChunkPos chunkPos) {
        return WorldUtils.isChunkLoaded(world, chunkPos.x, chunkPos.z);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isChunkLoaded(@Nullable LevelReader world, int chunkX, int chunkZ) {
        block4: {
            LevelAccessor accessor;
            block5: {
                if (world == null) {
                    return false;
                }
                if (!(world instanceof LevelAccessor)) break block4;
                accessor = (LevelAccessor)world;
                if (!(accessor instanceof Level)) break block5;
                Level level = (Level)accessor;
                if (level.isClientSide) break block4;
            }
            return accessor.hasChunk(chunkX, chunkZ);
        }
        return world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).isInWorldBounds(pos)) {
                return false;
            }
            return WorldUtils.isChunkLoaded(reader, pos);
        }
        return true;
    }

    private static boolean isInWorldBound(BlockGetter world, long pos) {
        return !world.isOutsideBuildHeight(BlockPos.getY((long)pos)) && WorldUtils.isInWorldBoundsHorizontal(pos);
    }

    private static boolean isInWorldBoundsHorizontal(long pos) {
        int x = BlockPos.getX((long)pos);
        int z = BlockPos.getZ((long)pos);
        return x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable BlockGetter world, long pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !WorldUtils.isInWorldBound((BlockGetter)(level = (Level)reader), pos)) {
                return false;
            }
            return WorldUtils.isChunkLoaded(reader, pos);
        }
        return true;
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockInBounds(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            return !(reader instanceof Level) || (level = (Level)reader).isInWorldBounds(pos);
        }
        return true;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    private static ChunkAccess getChunkForPos(@Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        int chunkZ;
        if (!WorldUtils.isBlockInBounds((BlockGetter)world, pos)) {
            return null;
        }
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        long combinedChunk = ChunkPos.asLong((int)chunkX, (int)(chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ())));
        ChunkAccess chunk = (ChunkAccess)chunkMap.get(combinedChunk);
        if (chunk == null && (chunk = world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false)) != null) {
            chunkMap.put(combinedChunk, (Object)chunk);
        }
        return chunk;
    }

    @NotNull
    public static Optional<BlockState> getBlockState(@Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        return WorldUtils.getBlockState((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @NotNull
    public static Optional<BlockState> getBlockState(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.getBlockState(pos));
    }

    @Nullable
    public static BlockState getBlockStateIfLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.getBlockState(pos);
    }

    @NotNull
    public static Optional<FluidState> getFluidState(@Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        return WorldUtils.getFluidState((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @NotNull
    public static Optional<FluidState> getFluidState(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return Optional.empty();
        }
        return Optional.of(world.getFluidState(pos));
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static BlockEntity getTileEntity(@Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        return WorldUtils.getTileEntity((BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@NotNull Class<T> clazz, @Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, chunkMap, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@NotNull Class<T> clazz, @Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos, boolean logWrongType) {
        return WorldUtils.getTileEntity(clazz, (BlockGetter)WorldUtils.getChunkForPos(world, chunkMap, pos), pos, logWrongType);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static BlockEntity getTileEntity(@Nullable BlockGetter world, long pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.getBlockEntity(BlockPos.of((long)pos));
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static BlockEntity getTileEntity(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.getBlockEntity(pos);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <CAP, CONTEXT> CAP getCapability(@Nullable Level level, BlockCapability<CAP, CONTEXT> cap, BlockPos pos, CONTEXT context) {
        return WorldUtils.getCapability(level, cap, pos, null, null, context);
    }

    @Nullable
    @Contract(value="null, _, _, _, _, _ -> null")
    public static <CAP, CONTEXT> CAP getCapability(@Nullable Level level, BlockCapability<CAP, CONTEXT> cap, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity tile, CONTEXT context) {
        if (!WorldUtils.isBlockLoaded((BlockGetter)level, pos)) {
            return null;
        }
        return (CAP)level.getCapability(cap, pos, state, tile, context);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@NotNull Class<T> clazz, @Nullable BlockGetter world, @NotNull BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, pos, false);
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(@NotNull Class<T> clazz, @Nullable BlockGetter world, @NotNull BlockPos pos, boolean logWrongType) {
        BlockEntity tile = WorldUtils.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (T)((BlockEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            Mekanism.logger.warn("Unexpected BlockEntity class at {}, expected {}, but found: {}", new Object[]{pos, clazz, tile.getClass()});
        }
        return null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        WorldUtils.markChunkDirty(world, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    public static void markChunkDirty(Level world, int chunkX, int chunkZ) {
        ChunkAccess chunk = world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
        if (chunk != null) {
            chunk.setUnsaved(true);
        }
    }

    public static void dismantleBlock(BlockState state, Level world, BlockPos pos, @Nullable Entity entity, ItemStack tool) {
        WorldUtils.dismantleBlock(state, world, pos, WorldUtils.getTileEntity((BlockGetter)world, pos), entity, tool);
    }

    public static void dismantleBlock(BlockState state, Level world, BlockPos pos, @Nullable BlockEntity tile, @Nullable Entity entity, ItemStack tool) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (ItemStack dropStack : WorldUtils.getDrops(state, level, pos, tile, entity, tool)) {
                    if (player.addItem(dropStack)) {
                        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (world.random.nextFloat() - world.random.nextFloat()) * 1.4f + 2.0f);
                        continue;
                    }
                    player.drop(dropStack, false);
                }
            } else {
                for (ItemEntity drop : WorldUtils.getDrops(state, level, pos, tile, entity, tool, true)) {
                    if (drop.getItem().isEmpty()) continue;
                    level.addFreshEntity((Entity)drop);
                }
            }
            state.spawnAfterBreak(level, pos, tool, false);
        }
        world.removeBlock(pos, false);
    }

    public static List<ItemEntity> getDrops(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity tile, @Nullable Entity entity, ItemStack tool, boolean applyMomentum) {
        List rawDrops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)tile, (Entity)entity, (ItemStack)tool);
        ArrayList<ItemEntity> initialDrops = new ArrayList<ItemEntity>(rawDrops.size());
        if (!rawDrops.isEmpty()) {
            double itemHeight = (double)EntityType.ITEM.getHeight() / 2.0;
            for (ItemStack rawDrop : rawDrops) {
                if (rawDrop.isEmpty()) continue;
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.5;
                double z = (double)pos.getZ() + 0.5;
                if (applyMomentum) {
                    x += Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
                    y += Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25) - itemHeight;
                    z += Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
                }
                ItemEntity item = new ItemEntity((Level)level, x, y, z, rawDrop);
                item.setDefaultPickUpDelay();
                initialDrops.add(item);
            }
        }
        BlockDropsEvent event = new BlockDropsEvent(level, pos, state, tile, initialDrops, entity, tool);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return Collections.emptyList();
        }
        return event.getDrops();
    }

    public static List<ItemStack> getDrops(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity tile, @Nullable Entity entity, ItemStack tool) {
        List<ItemEntity> drops = WorldUtils.getDrops(state, level, pos, tile, entity, tool, false);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(drops.size());
        for (ItemEntity drop : drops) {
            ItemStack stack = drop.getItem();
            if (stack.isEmpty()) continue;
            result.add(stack);
        }
        return result;
    }

    public static double distanceBetween(BlockPos start, BlockPos end) {
        return Math.sqrt(start.distSqr((Vec3i)end));
    }

    public static Direction sideDifference(BlockPos pos, BlockPos other) {
        int xDiff = pos.getX() - other.getX();
        int yDiff = pos.getY() - other.getY();
        int zDiff = pos.getZ() - other.getZ();
        return WorldUtils.getDirection(xDiff, yDiff, zDiff);
    }

    public static Direction sideDifference(long pos, long other) {
        int xDiff = BlockPos.getX((long)pos) - BlockPos.getX((long)other);
        int yDiff = BlockPos.getY((long)pos) - BlockPos.getY((long)other);
        int zDiff = BlockPos.getZ((long)pos) - BlockPos.getZ((long)other);
        return WorldUtils.getDirection(xDiff, yDiff, zDiff);
    }

    @Nullable
    private static Direction getDirection(int xDiff, int yDiff, int zDiff) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (side.getStepX() != xDiff || side.getStepY() != yDiff || side.getStepZ() != zDiff) continue;
            return side;
        }
        return null;
    }

    public static boolean isInsideFormedMultiblock(BlockGetter reader, BlockPos pos, @Nullable Mob mob) {
        IInternalMultiblock internalMultiblock;
        IStructuralMultiblock structuralMultiblock;
        BlockEntity tile = WorldUtils.getTileEntity(reader, pos);
        if (tile instanceof IMultiblock) {
            LevelReader levelReader;
            IMultiblock multiblockTile = (IMultiblock)tile;
            if (reader instanceof LevelReader && (levelReader = (LevelReader)reader).isClientSide() || mob != null && mob.level().isClientSide()) {
                return ((MultiblockData)multiblockTile.getMultiblock()).isFormed();
            }
            return ((MultiblockData)multiblockTile.getMultiblock()).isPositionInsideBounds(multiblockTile.getStructure(), pos.above());
        }
        if (tile instanceof IStructuralMultiblock && (structuralMultiblock = (IStructuralMultiblock)tile).hasFormedMultiblock()) {
            LevelReader levelReader;
            if (reader instanceof LevelReader && (levelReader = (LevelReader)reader).isClientSide() || mob != null && mob.level().isClientSide()) {
                return true;
            }
            BlockPos above = pos.above();
            for (Structure structure : structuralMultiblock.getStructureMap().values()) {
                MultiblockData data = structure.getMultiblockData();
                if (data == null || !data.isFormed() || !data.isPositionInsideBounds(structure, above)) continue;
                return true;
            }
            return false;
        }
        return tile instanceof IInternalMultiblock && (internalMultiblock = (IInternalMultiblock)tile).hasFormedMultiblock();
    }

    public static boolean isChunkVibrated(ChunkPos chunk, Level world) {
        for (GlobalPos coord : Mekanism.activeVibrators) {
            if (coord.dimension() != world.dimension() || SectionPos.blockToSectionCoord((int)coord.pos().getX()) != chunk.x || SectionPos.blockToSectionCoord((int)coord.pos().getZ()) != chunk.z) continue;
            return true;
        }
        return false;
    }

    public static boolean tryPlaceContainedLiquid(@Nullable Player player, Level world, BlockPos pos, @NotNull FluidStack fluidStack, @Nullable Direction side) {
        LiquidBlockContainer liquidBlockContainer;
        boolean canContainFluid;
        Fluid fluid = fluidStack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        if (!fluidType.canBePlacedInLevel((BlockAndTintGetter)world, pos, fluidStack)) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        boolean isReplaceable = state.canBeReplaced(fluid);
        Block block = state.getBlock();
        boolean bl = canContainFluid = block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos, state, fluid);
        if (state.isAir() || isReplaceable || canContainFluid) {
            if (fluidType.isVaporizedOnPlacement(world, pos, fluidStack)) {
                fluidType.onVaporize(player, world, pos, fluidStack);
            } else if (canContainFluid) {
                if (!((LiquidBlockContainer)state.getBlock()).placeLiquid((LevelAccessor)world, pos, state, fluidType.getStateForPlacement((BlockAndTintGetter)world, pos, fluidStack))) {
                    return false;
                }
                WorldUtils.playEmptySound(player, (LevelAccessor)world, pos, fluidType);
            } else {
                if (!world.isClientSide() && isReplaceable && !state.liquid()) {
                    world.destroyBlock(pos, true);
                }
                WorldUtils.playEmptySound(player, (LevelAccessor)world, pos, fluidType);
                world.setBlock(pos, fluid.defaultFluidState().createLegacyBlock(), 11);
            }
            return true;
        }
        return side != null && WorldUtils.tryPlaceContainedLiquid(player, world, pos.relative(side), fluidStack, null);
    }

    private static void playEmptySound(@Nullable Player player, LevelAccessor world, BlockPos pos, FluidType fluidType) {
        SoundEvent soundevent = fluidType.getSound(player, (BlockGetter)world, pos, SoundActions.BUCKET_EMPTY);
        if (soundevent != null) {
            world.playSound(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void playFillSound(@Nullable Player player, LevelAccessor world, BlockPos pos, @NotNull FluidStack fluidStack, @Nullable SoundEvent soundEvent) {
        if (soundEvent == null) {
            Fluid fluid = fluidStack.getFluid();
            Optional pickupSound = fluid.getPickupSound();
            soundEvent = pickupSound.isPresent() ? (SoundEvent)pickupSound.get() : fluid.getFluidType().getSound(player, (BlockGetter)world, pos, SoundActions.BUCKET_FILL);
        }
        if (soundEvent != null) {
            world.playSound(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean isGettingPowered(Level world, BlockPos pos) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockState blockState;
                boolean weakPower;
                offset.setWithOffset((Vec3i)pos, side);
                if (!WorldUtils.isBlockLoaded((BlockGetter)world, (BlockPos)offset) || (!(weakPower = (blockState = world.getBlockState((BlockPos)offset)).getBlock().shouldCheckWeakPower(blockState, (SignalGetter)world, pos, side)) || !WorldUtils.isDirectlyGettingPowered(world, (BlockPos)offset)) && (weakPower || blockState.getSignal((BlockGetter)world, (BlockPos)offset, side) <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction side : EnumUtils.DIRECTIONS) {
            offset.setWithOffset((Vec3i)pos, side);
            if (!WorldUtils.isBlockLoaded((BlockGetter)world, (BlockPos)offset) || world.getSignal(pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean areBlocksValidAndReplaceable(@NotNull BlockGetter world, @Nullable BlockPlaceContext baseContext, BlockPos ... positions) {
        for (BlockPos position : positions) {
            if (WorldUtils.isValidReplaceableBlock(world, baseContext, position)) continue;
            return false;
        }
        return true;
    }

    public static boolean areBlocksValidAndReplaceable(@NotNull BlockGetter world, @Nullable BlockPlaceContext baseContext, @NotNull Collection<BlockPos> positions) {
        for (BlockPos position : positions) {
            if (WorldUtils.isValidReplaceableBlock(world, baseContext, position)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidReplaceableBlock(@NotNull BlockGetter world, @Nullable BlockPlaceContext baseContext, @NotNull BlockPos pos) {
        Optional<BlockState> blockState = WorldUtils.getBlockState(world, pos);
        if (blockState.isPresent()) {
            BlockState state = blockState.get();
            if (baseContext == null) {
                return state.canBeReplaced();
            }
            return state.canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)baseContext, (BlockPos)pos, (Direction)baseContext.getClickedFace()));
        }
        return false;
    }

    public static void notifyLoadedNeighborsOfTileChange(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : EnumUtils.DIRECTIONS) {
            offset.setWithOffset((Vec3i)pos, dir);
            if (!WorldUtils.isBlockLoaded((BlockGetter)world, (BlockPos)offset)) continue;
            BlockState offsetState = world.getBlockState((BlockPos)offset);
            offsetState.onNeighborChange((LevelReader)world, (BlockPos)offset, pos);
            offsetState.handleNeighborChanged(world, (BlockPos)offset, state.getBlock(), pos, false);
            if (!offsetState.isRedstoneConductor((BlockGetter)world, (BlockPos)offset)) continue;
            offset.move(dir);
            if (!WorldUtils.isBlockLoaded((BlockGetter)world, (BlockPos)offset) || !(offsetState = world.getBlockState((BlockPos)offset)).getWeakChanges((LevelReader)world, (BlockPos)offset)) continue;
            offsetState.onNeighborChange((LevelReader)world, (BlockPos)offset, pos);
        }
    }

    public static void notifyNeighborOfChange(@Nullable Level world, BlockPos pos, BlockPos fromPos) {
        Optional<BlockState> blockState = WorldUtils.getBlockState((BlockGetter)world, pos);
        if (blockState.isPresent() && world != null) {
            BlockState state = blockState.get();
            state.onNeighborChange((LevelReader)world, pos, fromPos);
            state.handleNeighborChanged(world, pos, world.getBlockState(fromPos).getBlock(), fromPos, false);
        }
    }

    public static void updateBlock(@Nullable Level world, @NotNull BlockPos pos, BlockState state) {
        if (WorldUtils.isBlockLoaded((BlockGetter)world, pos)) {
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public static float getSunBrightness(Level world, float partialTicks) {
        float f = world.getTimeOfDay(partialTicks);
        float f1 = 1.0f - (Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.getRainLevel(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.getThunderLevel(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @Contract(value="null, _ -> false")
    public static boolean canSeeSun(@Nullable Level world, BlockPos pos) {
        return world != null && world.dimensionType().hasSkyLight() && world.getSkyDarken() < 4 && world.canSeeSky(pos);
    }

    public static BlockPos getBlockPosFromChunkPos(long chunkPos) {
        return new BlockPos((int)chunkPos, 0, (int)(chunkPos >> 32));
    }

    public static long relativePos(long pos, Direction direction) {
        return BlockPos.asLong((int)(BlockPos.getX((long)pos) + direction.getStepX()), (int)(BlockPos.getY((long)pos) + direction.getStepY()), (int)(BlockPos.getZ((long)pos) + direction.getStepZ()));
    }
}

