/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntitySeismicVibrator
extends TileEntityMekanism
implements IBoundingBlock {
    public int clientPiston;
    private MachineEnergyContainer<TileEntitySeismicVibrator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntitySeismicVibrator(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.SEISMIC_VIBRATOR, pos, state);
        this.cacheCoord();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this.facingSupplier);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntitySeismicVibrator)this).getLevel(), listener, 143, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            ++this.clientPiston;
        }
        this.updateActiveVibrators();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (this.canFunction()) {
            long energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL) == energyPerTick) {
                this.setActive(true);
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.ticker % 40 == 0) {
                    this.level.gameEvent(null, MekanismGameEvents.SEISMIC_VIBRATION, this.worldPosition);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.updateActiveVibrators();
        return sendUpdatePacket;
    }

    private void updateActiveVibrators() {
        if (this.getActive()) {
            Mekanism.activeVibrators.add(this.getTileGlobalPos());
        } else {
            Mekanism.activeVibrators.remove(this.getTileGlobalPos());
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        Mekanism.activeVibrators.remove(this.getTileGlobalPos());
    }

    public MachineEnergyContainer<TileEntitySeismicVibrator> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    boolean isVibrating() {
        return this.getActive();
    }

    private void validateVibrating() throws ComputerException {
        if (!this.isVibrating()) {
            throw new ComputerException("Seismic Vibrator is not currently vibrating any chunks");
        }
    }

    private BlockPos getVerticalPos(int chunkRelativeX, int y, int chunkRelativeZ) throws ComputerException {
        if (chunkRelativeX < 0 || chunkRelativeX > 15) {
            throw new ComputerException("Chunk Relative X '%d' is out of range must be between 0 and 15. (Inclusive)", chunkRelativeX);
        }
        if (chunkRelativeZ < 0 || chunkRelativeZ > 15) {
            throw new ComputerException("Chunk Relative Z '%d' is out of range must be between 0 and 15. (Inclusive)", chunkRelativeZ);
        }
        int x = SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)this.worldPosition.getX()), (int)chunkRelativeX);
        int z = SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)this.worldPosition.getZ()), (int)chunkRelativeZ);
        return new BlockPos(x, y, z);
    }

    @ComputerMethod
    BlockState getBlockAt(int chunkRelativeX, int y, int chunkRelativeZ) throws ComputerException {
        this.validateVibrating();
        if (this.level.isOutsideBuildHeight(y)) {
            throw new ComputerException("Y '%d' is out of range must be between %d and %d. (Inclusive)", y, this.level.getMinBuildHeight(), this.level.getMaxBuildHeight() - 1);
        }
        BlockPos targetPos = this.getVerticalPos(chunkRelativeX, y, chunkRelativeZ);
        return this.level.getBlockState(targetPos);
    }

    @ComputerMethod(methodDescription="Get a column info, table key is the Y level")
    Map<Integer, BlockState> getColumnAt(int chunkRelativeX, int chunkRelativeZ) throws ComputerException {
        this.validateVibrating();
        Int2ObjectOpenHashMap blocks = new Int2ObjectOpenHashMap();
        BlockPos minPos = this.getVerticalPos(chunkRelativeX, this.level.getMinBuildHeight(), chunkRelativeZ);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)new BlockPos(minPos.getX(), this.level.getMaxBuildHeight(), minPos.getZ()))) {
            blocks.put(pos.getY(), (Object)this.level.getBlockState(pos));
        }
        return blocks;
    }
}

