/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityItemStackChemicalToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackChemicalToItemStackRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<ItemStackChemicalToItemStackRecipe>,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler {
    protected static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ChemicalStack, ItemStackChemicalToItemStackRecipe, ItemStack> OUTPUT_CHECK = (recipe, input, extra, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput((ItemStack)input, (ChemicalStack)extra), output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final ILongInputHandler<@NotNull ChemicalStack> chemicalInputHandler = InputHelper.getConstantInputHandler(this.chemicalTank);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItem"}, docPlaceholder="chemical item (extra) slot")
    ChemicalInventorySlot extraSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="chemical tank")
    IChemicalTank chemicalTank;
    private final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsageMultiplier;
    private final long[] usedSoFar;
    private double chemicalPerTickMeanMultiplier = 1.0;
    private long baseTotalUsage;

    public TileEntityItemStackChemicalToItemStackFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        if (this.allowExtractingChemical()) {
            this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, this.chemicalTank, RelativeSide.RIGHT).setCanEject(false);
        } else {
            this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, this.chemicalTank);
        }
        this.baseTotalUsage = 200L;
        this.usedSoFar = new long[this.tier.processes];
        this.chemicalUsageMultiplier = this.useStatisticalMechanics() ? (usedSoFar, operatingTicks) -> StatUtils.inversePoisson(this.chemicalPerTickMeanMultiplier) : ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier.constantUse(() -> this.baseTotalUsage, this::getTicksRequired);
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig(this);
        long capacity = Attribute.getOrThrow(this.getBlockHolder(), AttributeFactoryType.class).getFactoryType() == FactoryType.INFUSING ? 1000L : 210L;
        this.chemicalTank = this.allowExtractingChemical() ? BasicChemicalTank.createModern(capacity * (long)this.tier.processes, this::containsRecipeB, this.markAllMonitorsChanged(listener)) : BasicChemicalTank.inputModern(capacity * (long)this.tier.processes, this::containsRecipeB, this.markAllMonitorsChanged(listener));
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.extraSlot = ChemicalInventorySlot.fillOrConvert(this.chemicalTank, () -> ((TileEntityItemStackChemicalToItemStackFactory)this).getLevel(), listener, 7, 57);
        builder.addSlot(this.extraSlot);
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    @Override
    @Nullable
    protected ChemicalInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.chemicalTank.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(ItemStackChemicalToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt(recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackChemicalToItemStackRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            ItemStackChemicalToItemStackRecipe cachedRecipe = cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.chemicalTank.isEmpty() || cachedRecipe.getChemicalInput().testType(this.chemicalTank.getTypeHolder()));
        }
        return false;
    }

    @Override
    protected ItemStackChemicalToItemStackRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return this.getRecipeType().getInputCache().findTypeBasedRecipe(this.level, fallbackInput, this.chemicalTank.getStack(), outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @Override
    @NotNull
    public IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, InputRecipeCache.ItemChemical<ItemStackChemicalToItemStackRecipe>> getRecipeType() {
        return switch (this.type) {
            case FactoryType.COMPRESSING -> MekanismRecipeType.COMPRESSING;
            case FactoryType.INFUSING -> MekanismRecipeType.METALLURGIC_INFUSING;
            case FactoryType.INJECTING -> MekanismRecipeType.INJECTING;
            case FactoryType.PURIFYING -> MekanismRecipeType.PURIFYING;
            default -> throw new IllegalStateException("Unhandled factory type");
        };
    }

    @Override
    public IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe> recipeViewerType() {
        return switch (this.type) {
            case FactoryType.COMPRESSING -> RecipeViewerRecipeType.COMPRESSING;
            case FactoryType.INFUSING -> RecipeViewerRecipeType.METALLURGIC_INFUSING;
            case FactoryType.INJECTING -> RecipeViewerRecipeType.INJECTING;
            case FactoryType.PURIFYING -> RecipeViewerRecipeType.PURIFYING;
            default -> throw new IllegalStateException("Unhandled factory type");
        };
    }

    private boolean allowExtractingChemical() {
        FactoryType factoryType = Attribute.getOrThrow(this.getBlockHolder(), AttributeFactoryType.class).getFactoryType();
        return factoryType == FactoryType.COMPRESSING || factoryType == FactoryType.INFUSING;
    }

    private boolean useStatisticalMechanics() {
        return MekanismConfig.usage.randomizedConsumption.get() && (this.type == FactoryType.INJECTING || this.type == FactoryType.PURIFYING);
    }

    @Override
    @Nullable
    public ItemStackChemicalToItemStackRecipe getRecipe(int cacheIndex) {
        return (ItemStackChemicalToItemStackRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.chemicalInputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<ItemStackChemicalToItemStackRecipe> createNewCachedRecipe(@NotNull ItemStackChemicalToItemStackRecipe recipe, int cacheIndex) {
        CachedRecipe cachedRecipe = recipe.perTickUsage() ? ItemStackConstantChemicalToObjectCachedRecipe.toItem(recipe, this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.chemicalInputHandler, this.chemicalUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, this.outputHandlers[cacheIndex]) : TwoInputCachedRecipe.itemChemicalToItem(recipe, this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.chemicalInputHandler, this.outputHandlers[cacheIndex]);
        return cachedRecipe.setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(this::canFunction).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(this::markForSave).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("used_so_far", 12)) {
            long[] savedUsed = nbt.getLongArray("used_so_far");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLongArray("used_so_far", Arrays.copyOf(this.usedSoFar, this.usedSoFar.length));
    }

    @Override
    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.CHEMICAL && this.supportsUpgrade(Upgrade.CHEMICAL)) {
            if (this.useStatisticalMechanics()) {
                this.chemicalPerTickMeanMultiplier = MekanismUtils.getGasPerTickMeanMultiplier(this);
            } else {
                this.baseTotalUsage = MekanismUtils.getBaseUsage(this, 200);
            }
        }
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.chemicalTank.deserializeNBT(provider, data.stored.serializeNBT(provider));
            this.extraSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Override
    @NotNull
    public AdvancedMachineUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new AdvancedMachineUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.usedSoFar, this.chemicalTank, this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @Override
    public void dump() {
        this.chemicalTank.setEmpty();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Empty the contents of the chemical tank into the environment")
    void dumpChemical() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dump();
    }
}

