/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.List;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public interface ITileComponent {
    public String getComponentKey();

    default public void read(CompoundTag nbtTags, HolderLookup.Provider provider) {
        NBTUtils.setCompoundIfPresent(nbtTags, this.getComponentKey(), tag -> this.deserialize((CompoundTag)tag, provider));
    }

    default public void write(CompoundTag nbtTags, HolderLookup.Provider provider) {
        CompoundTag componentTag = this.serialize(provider);
        if (!componentTag.isEmpty()) {
            nbtTags.put(this.getComponentKey(), (Tag)componentTag);
        }
    }

    public void deserialize(CompoundTag var1, HolderLookup.Provider var2);

    public CompoundTag serialize(HolderLookup.Provider var1);

    default public void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
    }

    default public void collectImplicitComponents(DataComponentMap.Builder builder) {
    }

    default public void addRemapEntries(List<DataComponentType<?>> remapEntries) {
    }

    default public void invalidate() {
    }

    default public void removed() {
    }

    default public void trackForMainContainer(MekanismContainer container) {
    }

    default public void addToUpdateTag(CompoundTag updateTag) {
    }

    default public void readFromUpdateTag(CompoundTag updateTag) {
    }
}

