/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedLongValue;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum InductionProviderTier implements ITier
{
    BASIC(BaseTier.BASIC, 256000L),
    ADVANCED(BaseTier.ADVANCED, 2048000L),
    ELITE(BaseTier.ELITE, 0xFA0000L),
    ULTIMATE(BaseTier.ULTIMATE, 0x7D00000L);

    private final long baseOutput;
    private final BaseTier baseTier;
    @Nullable
    private CachedLongValue outputReference;

    private InductionProviderTier(BaseTier tier, long out) {
        this.baseOutput = out;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public long getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : this.outputReference.getOrDefault();
    }

    public long getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedLongValue outputReference) {
        this.outputReference = outputReference;
    }
}

