/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotShiftTake(UUID typeUUID) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketQIOItemViewerSlotShiftTake> TYPE = new CustomPacketPayload.Type(Mekanism.rl("qio_shift_take"));
    public static final StreamCodec<ByteBuf, PacketQIOItemViewerSlotShiftTake> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(PacketQIOItemViewerSlotShiftTake::new, PacketQIOItemViewerSlotShiftTake::typeUUID);

    @NotNull
    public CustomPacketPayload.Type<PacketQIOItemViewerSlotShiftTake> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        HashedItem itemType;
        QIOItemViewerContainer container;
        QIOFrequency freq;
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof QIOItemViewerContainer && (freq = (container = (QIOItemViewerContainer)abstractContainerMenu).getFrequency()) != null && (itemType = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(this.typeUUID)) != null) {
            ItemStack remainder;
            ItemStack maxExtract = itemType.createStack(itemType.getMaxStackSize());
            ItemStack simulatedExcess = container.simulateInsertIntoPlayerInventory(player.getUUID(), maxExtract);
            ItemStack extracted = freq.removeByType(itemType, maxExtract.getCount() - simulatedExcess.getCount());
            if (!(extracted.isEmpty() || (remainder = container.insertIntoPlayerInventory(player.getUUID(), extracted)).isEmpty() || (remainder = freq.addItem(remainder)).isEmpty())) {
                Mekanism.logger.error("QIO shift-click transfer resulted in lost items ({}). This shouldn't happen!", (Object)remainder);
                player.drop(remainder, false);
            }
        }
    }
}

