/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.frequency;

import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_server.frequency.TypedIdentity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketSetFrequencyColor(boolean next, TypedIdentity data) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketSetFrequencyColor> TYPE = new CustomPacketPayload.Type(Mekanism.rl("set_frequency_color"));
    public static final StreamCodec<FriendlyByteBuf, PacketSetFrequencyColor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PacketSetFrequencyColor::next, TypedIdentity.STREAM_CODEC, PacketSetFrequencyColor::data, PacketSetFrequencyColor::new);

    public <FREQ extends Frequency> PacketSetFrequencyColor(FREQ freq, boolean next) {
        this(next, new TypedIdentity(freq.getType(), freq.getIdentity()));
    }

    @NotNull
    public CustomPacketPayload.Type<PacketSetFrequencyColor> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        UUID player = context.player().getUUID();
        Object freq = this.data.type().getFrequency(this.data.data(), player);
        if (freq instanceof IColorableFrequency) {
            IColorableFrequency colorableFrequency = (IColorableFrequency)freq;
            if (((Frequency)freq).ownerMatches(player)) {
                EnumColor color = colorableFrequency.getColor();
                colorableFrequency.setColor(this.next ? (EnumColor)color.getNext() : (EnumColor)color.getPrevious());
            }
        }
    }
}

