/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.capabilities.EntityCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EntitySecurityUtils
implements IEntitySecurityUtils {
    private static final EntityCapability<IOwnerObject, Void> OWNER_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Capabilities.OWNER_OBJECT_NAME, IOwnerObject.class);
    private static final EntityCapability<ISecurityObject, Void> SECURITY_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Capabilities.SECURITY_OBJECT_NAME, ISecurityObject.class);

    public static EntitySecurityUtils get() {
        return (EntitySecurityUtils)INSTANCE;
    }

    @Override
    public EntityCapability<IOwnerObject, Void> ownerCapability() {
        return OWNER_CAPABILITY;
    }

    @Override
    public EntityCapability<ISecurityObject, Void> securityCapability() {
        return SECURITY_CAPABILITY;
    }

    public void securityChanged(Set<Player> playersUsing, Entity target, SecurityMode old, SecurityMode mode) {
        if (!playersUsing.isEmpty() && ISecurityUtils.INSTANCE.moreRestrictive(old, mode)) {
            CachingCapabilityLookup lookup = new CachingCapabilityLookup(target);
            for (Player player : new ObjectOpenHashSet(playersUsing)) {
                if (ISecurityUtils.INSTANCE.canAccess(player, lookup, CachingCapabilityLookup::securityCapability, CachingCapabilityLookup::ownerCapability)) continue;
                player.closeContainer();
            }
        }
    }

    private static class CachingCapabilityLookup {
        private final Entity target;
        @Nullable
        private ISecurityObject securityObject;
        @Nullable
        private IOwnerObject ownerObject;

        public CachingCapabilityLookup(Entity target) {
            this.target = target;
        }

        @Nullable
        ISecurityObject securityCapability() {
            if (this.securityObject == null) {
                this.securityObject = IEntitySecurityUtils.INSTANCE.securityCapability(this.target);
            }
            return this.securityObject;
        }

        @Nullable
        IOwnerObject ownerCapability() {
            if (this.ownerObject == null) {
                this.ownerObject = IEntitySecurityUtils.INSTANCE.ownerCapability(this.target);
            }
            return this.ownerObject;
        }
    }
}

