/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import mekanism.api.radiation.capability.IRadiationShielding;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.radiation.RadiationSource;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class RadiationUtil {
    public static long getDecayTime(double magnitude, boolean source) {
        double decayRate = source ? MekanismConfig.general.radiationSourceDecayRate.get() : MekanismConfig.general.radiationTargetDecayRate.get();
        long ticks = 0L;
        double localMagnitude = magnitude;
        while (localMagnitude > RadiationManager.get().minRadiationMagnitude()) {
            localMagnitude *= decayRate;
            ticks += 20L;
        }
        return ticks;
    }

    public static double getRadiationResistance(LivingEntity entity) {
        IItemHandler handler;
        double resistance = 0.0;
        for (EquipmentSlot type : EnumUtils.ARMOR_SLOTS) {
            IRadiationShielding shielding;
            ItemStack stack = entity.getItemBySlot(type);
            if (stack.isEmpty() || (shielding = (IRadiationShielding)stack.getCapability(Capabilities.RADIATION_SHIELDING)) == null) continue;
            resistance += shielding.getRadiationShielding();
        }
        if (resistance < 1.0 && Mekanism.hooks.curios.isLoaded() && (handler = CuriosIntegration.getCuriosInventory(entity)) != null) {
            int slots = handler.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                IRadiationShielding shielding = (IRadiationShielding)stack.getCapability(Capabilities.RADIATION_SHIELDING);
                if (shielding == null || !((resistance += shielding.getRadiationShielding()) >= 1.0)) continue;
                return 1.0;
            }
        }
        return resistance;
    }

    public static double computeExposure(RadiationSource source, BlockPos blockPos) {
        return source.getMagnitude() / Math.max(1.0, blockPos.distSqr((Vec3i)source.getPosition()));
    }
}

