/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radial.data;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.ClassBasedRadialData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnumRadialData<MODE extends Enum<MODE>>
extends ClassBasedRadialData<MODE> {
    private final List<MODE> modes;
    @Nullable
    private final MODE defaultMode;

    EnumRadialData(ResourceLocation identifier, MODE defaultMode) {
        super(identifier, ((Enum)Objects.requireNonNull(defaultMode, "Default mode cannot be null.")).getDeclaringClass());
        this.modes = List.of((Enum[])this.clazz.getEnumConstants());
        this.defaultMode = defaultMode;
    }

    EnumRadialData(ResourceLocation identifier, Class<MODE> enumClass) {
        super(identifier, enumClass);
        this.modes = List.of((Enum[])this.clazz.getEnumConstants());
        this.defaultMode = this.modes.isEmpty() ? null : (Enum)this.modes.getFirst();
    }

    @Override
    @Nullable
    public MODE getDefaultMode(List<MODE> modes) {
        return this.defaultMode;
    }

    @Override
    public List<MODE> getModes() {
        return this.modes;
    }

    @Override
    public int index(List<MODE> modes, MODE mode) {
        return ((Enum)mode).ordinal();
    }

    @Override
    public int getNetworkRepresentation(MODE mode) {
        return ((Enum)mode).ordinal();
    }

    @Override
    public MODE fromNetworkRepresentation(int networkRepresentation) {
        return (MODE)((Enum)MathUtils.getByIndexMod(this.modes, networkRepresentation));
    }
}

