/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Locale;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.gear.ItemChemicalArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismArmorMaterials;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ItemJetpack
extends ItemChemicalArmor
implements IItemHUDProvider,
IJetpackItem,
IModeItem.IAttachmentBasedModeItem<IJetpackItem.JetpackMode> {
    public ItemJetpack(Item.Properties properties) {
        this((Holder<ArmorMaterial>)MekanismArmorMaterials.JETPACK, properties);
    }

    public ItemJetpack(Holder<ArmorMaterial> material, Item.Properties properties) {
        super(material, ArmorItem.Type.CHESTPLATE, properties.setNoRepair().component(MekanismDataComponents.JETPACK_MODE, (Object)IJetpackItem.JetpackMode.NORMAL));
    }

    @Override
    protected Holder<Chemical> getChemicalType() {
        return MekanismChemicals.HYDROGEN;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, ((IJetpackItem.JetpackMode)this.getMode(stack)).getTextComponent()));
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        return this.hasChemical(stack);
    }

    @Override
    public DataComponentType<IJetpackItem.JetpackMode> getModeDataType() {
        return (DataComponentType)MekanismDataComponents.JETPACK_MODE.get();
    }

    @Override
    public IJetpackItem.JetpackMode getDefaultMode() {
        return IJetpackItem.JetpackMode.NORMAL;
    }

    @Override
    public IJetpackItem.JetpackMode getJetpackMode(ItemStack stack) {
        return (IJetpackItem.JetpackMode)this.getMode(stack);
    }

    @Override
    public double getJetpackThrust(ItemStack stack) {
        return 0.15;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        this.useChemical(stack, 1L);
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        if (slotType == this.getEquipmentSlot()) {
            ItemJetpack jetpack = (ItemJetpack)stack.getItem();
            list.add((Component)MekanismLang.JETPACK_MODE.translateColored(EnumColor.DARK_GRAY, jetpack.getMode(stack)));
            ChemicalStack stored = ChemicalStack.EMPTY;
            long capacity = 1L;
            IChemicalHandler gasHandlerItem = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
            if (gasHandlerItem != null && gasHandlerItem.getChemicalTanks() > 0) {
                stored = gasHandlerItem.getChemicalInTank(0);
                capacity = gasHandlerItem.getChemicalTankCapacity(0);
            }
            list.add((Component)MekanismLang.JETPACK_STORED.translateColored(EnumColor.DARK_GRAY, EnumColor.ORANGE, stored.getAmount(), String.format(Locale.ROOT, "%.0f", 100.0 * (double)stored.getAmount() / (double)capacity)));
        }
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        IJetpackItem.JetpackMode newMode;
        IJetpackItem.JetpackMode mode = (IJetpackItem.JetpackMode)this.getMode(stack);
        if (mode != (newMode = (IJetpackItem.JetpackMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, xva$0 -> MekanismLang.JETPACK_MODE_CHANGE.translate(xva$0));
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.getEquipmentSlot();
    }
}

