/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.prefab.BlockFactoryMachine;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.FactoryTier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ItemBlockFactory
extends ItemBlockTooltip<BlockTile<?, ?>> {
    private static AttachedSideConfig getSideConfig(BlockFactoryMachine.BlockFactory<?> block) {
        return switch (Attribute.getOrThrow((Holder<Block>)block.builtInRegistryHolder(), AttributeFactoryType.class).getFactoryType()) {
            default -> throw new MatchException(null, null);
            case FactoryType.SMELTING, FactoryType.ENRICHING, FactoryType.CRUSHING, FactoryType.SAWING -> AttachedSideConfig.ELECTRIC_MACHINE;
            case FactoryType.COMPRESSING, FactoryType.INFUSING -> AttachedSideConfig.ADVANCED_MACHINE;
            case FactoryType.COMBINING -> AttachedSideConfig.EXTRA_MACHINE;
            case FactoryType.PURIFYING, FactoryType.INJECTING -> AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY;
        };
    }

    public ItemBlockFactory(BlockFactoryMachine.BlockFactory<?> block, Item.Properties properties) {
        super(block, true, properties.component(MekanismDataComponents.SORTING, (Object)false).component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)ItemBlockFactory.getSideConfig(block)));
    }

    @Override
    public FactoryTier getTier() {
        return Attribute.getTier(this.getBlock(), FactoryTier.class);
    }

    @Override
    protected void addTypeDetails(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        AttributeFactoryType factoryType = Attribute.get(this.getBlock(), AttributeFactoryType.class);
        if (factoryType != null) {
            tooltip.add((Component)MekanismLang.FACTORY_TYPE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, factoryType.getFactoryType()));
        }
        super.addTypeDetails(stack, context, tooltip, flag);
    }
}

