/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PortableTeleporterContainer
extends FrequencyItemContainer<TeleporterFrequency>
implements IEmptyContainer {
    private TileEntityTeleporter.TeleporterStatus status = TileEntityTeleporter.TeleporterStatus.NO_FREQUENCY;

    public PortableTeleporterContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(MekanismContainerTypes.PORTABLE_TELEPORTER, id, inv, hand, stack);
    }

    @Nullable
    public IEnergyContainer getEnergyContainer() {
        return StorageUtils.getEnergyContainer(this.stack, 0);
    }

    public TileEntityTeleporter.TeleporterStatus getStatus() {
        return this.status;
    }

    @Override
    protected FrequencyType<TeleporterFrequency> getFrequencyType() {
        return FrequencyType.TELEPORTER;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        if (this.getLevel().isClientSide()) {
            this.track(SyncableEnum.create(TileEntityTeleporter.TeleporterStatus.BY_ID, TileEntityTeleporter.TeleporterStatus.NO_FREQUENCY, this::getStatus, value -> {
                this.status = value;
            }));
        } else {
            this.track(SyncableEnum.create(TileEntityTeleporter.TeleporterStatus.BY_ID, TileEntityTeleporter.TeleporterStatus.NO_FREQUENCY, () -> {
                TeleporterFrequency freq = (TeleporterFrequency)this.getFrequencyFromStack();
                if (freq == null) {
                    return TileEntityTeleporter.TeleporterStatus.NO_FREQUENCY;
                }
                if (freq.getActiveCoords().isEmpty()) {
                    return TileEntityTeleporter.TeleporterStatus.NO_DESTINATION;
                }
                if (!this.inv.player.isCreative()) {
                    long energyNeeded;
                    IEnergyContainer energyContainer = this.getEnergyContainer();
                    if (energyContainer == null) {
                        return TileEntityTeleporter.TeleporterStatus.NOT_ENOUGH_ENERGY;
                    }
                    GlobalPos coords = freq.getClosestCoords(GlobalPos.of((ResourceKey)this.getLevel().dimension(), (BlockPos)this.inv.player.blockPosition()));
                    if (coords != null && (energyNeeded = TileEntityTeleporter.calculateEnergyCost((Entity)this.inv.player, coords)) != -1L && energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL) < energyNeeded) {
                        return TileEntityTeleporter.TeleporterStatus.NOT_ENOUGH_ENERGY;
                    }
                }
                return TileEntityTeleporter.TeleporterStatus.READY;
            }, value -> {
                this.status = value;
            }));
        }
    }
}

