/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.text.InputValidator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialConverters {
    @Nullable
    public static <ENUM extends Enum<?>> ENUM sanitizeStringToEnum(Class<? extends ENUM> expectedType, String argument) {
        if (!argument.isEmpty()) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])expectedType.getEnumConstants()) {
                if (!argument.equalsIgnoreCase(enumConstant.name())) continue;
                return (ENUM)enumConstant;
            }
        }
        return null;
    }

    private static ItemStack tryCreateFilterItem(@Nullable String rawName, @Nullable String rawComponents) throws ComputerException {
        Item item = SpecialConverters.tryCreateItem(rawName);
        if (item == Items.AIR) {
            return ItemStack.EMPTY;
        }
        if (rawComponents != null) {
            DataComponentPatch dataComponents = SpecialConverters.unwrapComponents(rawComponents);
            return new ItemStack((Holder)item.builtInRegistryHolder(), 1, dataComponents);
        }
        return new ItemStack((ItemLike)item);
    }

    private static Item tryCreateItem(@Nullable Object rawName) {
        String name;
        ResourceLocation itemName;
        if (rawName instanceof String && (itemName = ResourceLocation.tryParse((String)(name = (String)rawName))) != null) {
            return (Item)BuiltInRegistries.ITEM.get(itemName);
        }
        return Items.AIR;
    }

    @Nullable
    private static String tryGetFilterTag(@Nullable Object rawTag) {
        String tag;
        if (rawTag instanceof String && !(tag = (String)rawTag).isEmpty() && InputValidator.test(tag = tag.toLowerCase(Locale.ROOT), InputValidator.RESOURCE_LOCATION.or(InputValidator.WILDCARD_CHARS))) {
            return tag;
        }
        return null;
    }

    @Nullable
    private static String tryGetFilterModId(@Nullable Object rawModId) {
        String modId;
        if (rawModId instanceof String && !(modId = (String)rawModId).isEmpty() && InputValidator.test(modId = modId.toLowerCase(Locale.ROOT), InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS))) {
            return modId;
        }
        return null;
    }

    private static boolean getBooleanFromRaw(@Nullable Object raw) {
        boolean bl;
        if (raw instanceof Boolean) {
            Boolean bool = (Boolean)raw;
            bl = bool;
        } else {
            bl = false;
        }
        return bl;
    }

    static int getIntFromRaw(@Nullable Object raw) {
        int n;
        if (raw instanceof Number) {
            Number number = (Number)raw;
            n = number.intValue();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public static <FILTER extends IFilter<FILTER>> FILTER convertMapToFilter(@NotNull Class<FILTER> expectedType, @NotNull Map<?, ?> map) throws ComputerException {
        Object type = map.get("type");
        if (!(type instanceof String)) {
            throw new ComputerException("Missing 'type' element");
        }
        String string = (String)type;
        FilterType filterType = SpecialConverters.sanitizeStringToEnum(FilterType.class, string);
        if (filterType == null) {
            throw new ComputerException("Unknown 'type' value");
        }
        IFilter<?> filter = BaseFilter.fromType(filterType);
        if (!expectedType.isInstance(filter)) {
            throw new ComputerException("Unexpected format for: type");
        }
        Object enabled = map.get("enabled");
        if (enabled instanceof Boolean) {
            Boolean enable = (Boolean)enabled;
            filter.setEnabled(enable);
        }
        IFilter<?> iFilter = filter;
        Objects.requireNonNull(iFilter);
        IFilter<?> iFilter2 = iFilter;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IItemStackFilter.class, IModIDFilter.class, ITagFilter.class}, iFilter2, n)) {
            case 0: {
                IItemStackFilter itemFilter = (IItemStackFilter)iFilter2;
                SpecialConverters.decodeItemStackFilter(map, itemFilter);
                break;
            }
            case 1: {
                IModIDFilter modIDFilter = (IModIDFilter)iFilter2;
                SpecialConverters.decodeModIdFilter(map, modIDFilter);
                break;
            }
            case 2: {
                ITagFilter tagFilter = (ITagFilter)iFilter2;
                SpecialConverters.decodeTagFilter(map, tagFilter);
                break;
            }
        }
        IFilter<?> iFilter3 = filter;
        Objects.requireNonNull(iFilter3);
        iFilter2 = iFilter3;
        n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MinerFilter.class, SorterFilter.class, QIOFilter.class, OredictionificatorFilter.class}, iFilter2, n)) {
            case 0: {
                MinerFilter minerFilter = (MinerFilter)iFilter2;
                SpecialConverters.decodeMinerFilter(map, minerFilter);
                break;
            }
            case 1: {
                SorterFilter sorterFilter = (SorterFilter)iFilter2;
                SpecialConverters.decodeSorterFilter(map, sorterFilter);
                break;
            }
            case 2: {
                QIOFilter qioFilter = (QIOFilter)iFilter2;
                SpecialConverters.decodeQioFilter(map, qioFilter);
                break;
            }
            case 3: {
                OredictionificatorFilter oredictionificatorFilter = (OredictionificatorFilter)iFilter2;
                SpecialConverters.decodeOreDictFilter(map, oredictionificatorFilter);
                break;
            }
        }
        return (FILTER)((IFilter)expectedType.cast(filter));
    }

    private static void decodeOreDictFilter(@NotNull Map<?, ?> map, OredictionificatorFilter<?, ?, ?> oredictionificatorFilter) throws ComputerException {
        String tag;
        Object rawTag = map.get("target");
        if (!(rawTag instanceof String) || (tag = (String)rawTag).isEmpty()) {
            throw new ComputerException("Missing 'target'");
        }
        ResourceLocation rl = ResourceLocation.tryParse((String)tag);
        if (rl == null || !TileEntityOredictionificator.isValidTarget(rl)) {
            throw new ComputerException("Invalid 'target'");
        }
        oredictionificatorFilter.setFilter(rl);
        if (oredictionificatorFilter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter itemFilter = (OredictionificatorItemFilter)oredictionificatorFilter;
            Item item = SpecialConverters.tryCreateItem(map.get("selected"));
            if (item != Items.AIR) {
                itemFilter.setSelectedOutput(item.builtInRegistryHolder());
            }
        }
    }

    private static void decodeQioFilter(@NotNull Map<?, ?> map, QIOFilter<?> qioFilter) {
        if (qioFilter instanceof QIOItemStackFilter) {
            QIOItemStackFilter qioItemFilter = (QIOItemStackFilter)qioFilter;
            qioItemFilter.fuzzyMode = SpecialConverters.getBooleanFromRaw(map.get("fuzzy"));
        }
    }

    private static void decodeSorterFilter(@NotNull Map<?, ?> map, SorterFilter<?> sorterFilter) throws ComputerException {
        sorterFilter.allowDefault = SpecialConverters.getBooleanFromRaw(map.get("allow_default"));
        Object rawColor = map.get("color");
        if (rawColor instanceof String) {
            sorterFilter.color = SpecialConverters.sanitizeStringToEnum(EnumColor.class, (String)rawColor);
        }
        sorterFilter.sizeMode = SpecialConverters.getBooleanFromRaw(map.get("size"));
        sorterFilter.min = SpecialConverters.getIntFromRaw(map.get("min"));
        sorterFilter.max = SpecialConverters.getIntFromRaw(map.get("max"));
        if (sorterFilter.min < 0 || sorterFilter.max < 0 || sorterFilter.min > sorterFilter.max || sorterFilter.max > 99) {
            throw new ComputerException("Invalid min/max: 0 <= min <= max <= 99");
        }
        if (sorterFilter instanceof SorterItemStackFilter) {
            SorterItemStackFilter sorterItemFilter = (SorterItemStackFilter)sorterFilter;
            sorterItemFilter.fuzzyMode = SpecialConverters.getBooleanFromRaw(map.get("fuzzy"));
        }
    }

    private static void decodeMinerFilter(@NotNull Map<?, ?> map, MinerFilter<?> minerFilter) {
        minerFilter.requiresReplacement = SpecialConverters.getBooleanFromRaw(map.get("requires_replacement"));
        minerFilter.replaceTarget = SpecialConverters.tryCreateItem(map.get("replace_target"));
    }

    private static void decodeTagFilter(@NotNull Map<?, ?> map, ITagFilter<?> tagFilter) throws ComputerException {
        String tag = SpecialConverters.tryGetFilterTag(map.get("tag"));
        if (tag == null) {
            throw new ComputerException("Invalid or missing tag specified for Tag filter");
        }
        tagFilter.setTagName(tag);
    }

    private static void decodeModIdFilter(@NotNull Map<?, ?> map, IModIDFilter<?> modIDFilter) throws ComputerException {
        String modId = SpecialConverters.tryGetFilterModId(map.get("modid"));
        if (modId == null) {
            throw new ComputerException("Invalid or missing modId specified for Mod Id filter");
        }
        modIDFilter.setModID(modId);
    }

    private static void decodeItemStackFilter(@NotNull Map<?, ?> map, IItemStackFilter<?> itemFilter) throws ComputerException {
        ItemStack stack = SpecialConverters.tryCreateFilterItem((String)map.get("item"), (String)map.get("components"));
        if (stack.isEmpty()) {
            throw new ComputerException("Invalid or missing item specified for ItemStack filter");
        }
        itemFilter.setItemStack(stack);
    }

    static Map<String, Object> wrapStack(String name, String sizeKey, int amount, @NotNull DataComponentPatch components) {
        boolean hasComponents;
        int elements = 2;
        boolean bl = hasComponents = !components.isEmpty() && amount > 0;
        if (hasComponents) {
            ++elements;
        }
        HashMap<String, Object> wrapped = new HashMap<String, Object>(elements);
        wrapped.put("name", name);
        wrapped.put(sizeKey, amount);
        if (hasComponents) {
            wrapped.put("components", SpecialConverters.wrapComponents(components));
        }
        return wrapped;
    }

    static String wrapComponents(@NotNull DataComponentPatch components) {
        return NbtUtils.structureToSnbt((CompoundTag)((CompoundTag)DataComponentPatch.CODEC.encodeStart(SpecialConverters.getRegistryNbtOps(), (Object)components).getOrThrow()));
    }

    static DataComponentPatch unwrapComponents(@NotNull String rawComponents) throws ComputerException {
        CompoundTag nbt;
        try {
            nbt = NbtUtils.snbtToStructure((String)rawComponents);
        }
        catch (CommandSyntaxException ex) {
            throw new ComputerException("Invalid SNBT: " + ex.getMessage());
        }
        return (DataComponentPatch)DataComponentPatch.CODEC.parse(SpecialConverters.getRegistryNbtOps(), (Object)nbt).getOrThrow(ComputerException::new);
    }

    private static DynamicOps<Tag> getRegistryNbtOps() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        }
        return NbtOps.INSTANCE;
    }
}

