/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.listener;

import java.util.function.Supplier;
import mekanism.common.config.value.CachedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigBasedCachedSupplier<VALUE>
implements Supplier<VALUE> {
    private final Supplier<VALUE> resolver;
    @Nullable
    private VALUE cachedValue;

    public ConfigBasedCachedSupplier(Supplier<VALUE> resolver, CachedValue<?> ... dependantConfigValues) {
        this.resolver = resolver;
        CachedValue.IConfigValueInvalidationListener refreshListener = this::refresh;
        for (CachedValue<?> configValue : dependantConfigValues) {
            configValue.addInvalidationListener(refreshListener);
        }
    }

    protected final void refresh() {
        this.cachedValue = this.resolver.get();
    }

    @Override
    @NotNull
    public VALUE get() {
        if (this.cachedValue == null) {
            this.refresh();
        }
        return this.cachedValue;
    }
}

