/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.listener;

import mekanism.api.functions.FloatSupplier;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedValue;

public class ConfigBasedCachedFloatSupplier
implements FloatSupplier {
    private final FloatSupplier resolver;
    private boolean resolved;
    private float cachedValue;

    public ConfigBasedCachedFloatSupplier(FloatSupplier resolver, CachedFloatValue ... dependantConfigValues) {
        this.resolver = resolver;
        CachedValue.IConfigValueInvalidationListener refreshListener = this::refresh;
        for (CachedFloatValue configValue : dependantConfigValues) {
            configValue.addInvalidationListener(refreshListener);
        }
    }

    protected final void refresh() {
        this.cachedValue = this.resolver.getAsFloat();
        this.resolved = true;
    }

    @Override
    public float getAsFloat() {
        if (!this.resolved) {
            this.refresh();
        }
        return this.cachedValue;
    }
}

