/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class TagCache {
    private static final HolderSet.Named<Block> MINER_BLACKLIST_LOOKUP = BuiltInRegistries.BLOCK.getOrCreateTag(MekanismTags.Blocks.MINER_BLACKLIST);
    private static final Map<String, MatchingStacks> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, MatchingStacks> blockModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<Block, List<String>> tileEntityTypeTagCache = new IdentityHashMap<Block, List<String>>();
    private static final Object2BooleanMap<String> blockTagBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<String> modIDBlacklistedElements = new Object2BooleanOpenHashMap();

    private TagCache() {
    }

    public static void resetTagCaches() {
        blockTagStacks.clear();
        itemTagStacks.clear();
        tileEntityTypeTagCache.clear();
        blockTagBlacklistedElements.clear();
        modIDBlacklistedElements.clear();
    }

    public static List<String> getItemTags(@NotNull ItemStack check) {
        return TagCache.getTagsAsStrings(check.getTags());
    }

    public static List<String> getTileEntityTypeTags(@NotNull Block block) {
        List<String> cache = tileEntityTypeTagCache.get(block);
        if (cache == null) {
            if (block instanceof IHasTileEntity) {
                IHasTileEntity hasTileEntity = (IHasTileEntity)block;
                cache = TagCache.getTagsAsStrings(hasTileEntity.getTileType());
            } else {
                BlockState state = block.defaultBlockState();
                cache = state.hasBlockEntity() ? TagCache.getTagsAsStrings(StreamSupport.stream(BuiltInRegistries.BLOCK_ENTITY_TYPE.spliterator(), false).filter(type -> type.isValid(state)).flatMap(type -> RegistryUtils.getBEHolder(type).tags()).distinct()) : Collections.emptyList();
            }
            tileEntityTypeTagCache.put(block, cache);
        }
        return cache;
    }

    public static <TYPE> List<String> getTagsAsStrings(@NotNull Holder<TYPE> holder) {
        return TagCache.getTagsAsStrings(holder.tags());
    }

    public static <TYPE> List<String> getTagsAsStrings(@NotNull Stream<TagKey<TYPE>> tags) {
        return tags.map(tag -> tag.location().toString()).toList();
    }

    public static List<ItemStack> getItemTagStacks(@NotNull String tagName) {
        return itemTagStacks.computeIfAbsent(tagName, name -> {
            Set<Item> items = TagCache.collectTagStacks(BuiltInRegistries.ITEM, name, item -> !MekanismBlocks.BOUNDING_BLOCK.isSecondary(item));
            return items.stream().map(ItemStack::new).filter(stack -> !stack.isEmpty()).toList();
        });
    }

    public static MatchingStacks getBlockTagStacks(@NotNull String tagName) {
        return blockTagStacks.computeIfAbsent(tagName, name -> {
            Set<Block> blocks = TagCache.collectTagStacks(BuiltInRegistries.BLOCK, name, block -> !MekanismBlocks.BOUNDING_BLOCK.is(block));
            return TagCache.getMatching(blocks);
        });
    }

    private static <TYPE> Set<TYPE> collectTagStacks(Registry<TYPE> registry, String tagName, Predicate<TYPE> validElement) {
        return registry.getTags().filter(pair -> WildcardMatcher.matches(tagName, (TagKey)pair.getFirst())).flatMap(pair -> ((HolderSet.Named)pair.getSecond()).stream()).map(Holder::value).filter(validElement).collect(Collectors.toSet());
    }

    private static MatchingStacks getMatching(Set<Block> blocks) {
        if (blocks.isEmpty()) {
            return MatchingStacks.NONE;
        }
        return new MatchingStacks(true, blocks.stream().map(ItemStack::new).filter(stack -> !stack.isEmpty()).toList());
    }

    public static List<ItemStack> getItemModIDStacks(@NotNull String modName) {
        return itemModIDStacks.computeIfAbsent(modName, name -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                ItemStack stack;
                if (MekanismBlocks.BOUNDING_BLOCK.getItemHolder().is((ResourceKey)entry.getKey()) || (stack = new ItemStack((ItemLike)entry.getValue())).isEmpty() || !WildcardMatcher.matches(name, MekanismUtils.getModId(stack))) continue;
                stacks.add(stack);
            }
            return stacks;
        });
    }

    public static MatchingStacks getBlockModIDStacks(@NotNull String modName) {
        return blockModIDStacks.computeIfAbsent(modName, name -> {
            ReferenceOpenHashSet blocks = new ReferenceOpenHashSet();
            for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
                if (MekanismBlocks.BOUNDING_BLOCK.is((ResourceKey)entry.getKey()) || !WildcardMatcher.matches(name, ((ResourceKey)entry.getKey()).location().getNamespace())) continue;
                blocks.add((Block)entry.getValue());
            }
            return TagCache.getMatching((Set<Block>)blocks);
        });
    }

    public static boolean tagHasMinerBlacklisted(@NotNull String tag) {
        if (MINER_BLACKLIST_LOOKUP.size() == 0) {
            return false;
        }
        return blockTagBlacklistedElements.computeIfAbsent((Object)tag, t -> BuiltInRegistries.BLOCK.getTags().anyMatch(pair -> WildcardMatcher.matches(t, (TagKey)pair.getFirst()) && ((HolderSet.Named)pair.getSecond()).stream().anyMatch(element -> element.is(MekanismTags.Blocks.MINER_BLACKLIST))));
    }

    public static boolean modIDHasMinerBlacklisted(@NotNull String modName) {
        if (MINER_BLACKLIST_LOOKUP.size() == 0) {
            return false;
        }
        return modIDBlacklistedElements.computeIfAbsent((Object)modName, name -> BuiltInRegistries.BLOCK.holders().anyMatch(holder -> holder.is(MekanismTags.Blocks.MINER_BLACKLIST) && WildcardMatcher.matches(name, holder.key().location().getNamespace())));
    }

    public record MatchingStacks(boolean hasMatch, List<ItemStack> stacks) {
        private static final MatchingStacks NONE = new MatchingStacks(false, Collections.emptyList());
    }
}

