/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.HUDRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.tags.MekanismTags;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MekanismHUD
implements LayeredDraw.Layer {
    public static final MekanismHUD INSTANCE = new MekanismHUD();
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final HUDRenderer hudRenderer = new HUDRenderer();

    private MekanismHUD() {
    }

    @Nullable
    private IItemHUDProvider getHudProvider(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IItemHUDProvider) {
            IItemHUDProvider hudProvider = (IItemHUDProvider)item;
            return hudProvider;
        }
        return (list, player, s, slotType) -> {
            IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainer(s);
            if (container != null) {
                list.addAll(container.getHUDStrings(player, s));
            }
        };
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && !player.isSpectator() && !minecraft.options.hideGui && MekanismConfig.client.enableHUD.get()) {
            IItemHandler inv;
            int count = 0;
            ArrayList<List<Component>> renderStrings = new ArrayList<List<Component>>();
            for (EquipmentSlot slotType : EQUIPMENT_ORDER) {
                ItemStack stack = player.getItemBySlot(slotType);
                IItemHUDProvider hudProvider = this.getHudProvider(stack);
                if (hudProvider == null) continue;
                count += this.makeComponent(hudProvider, (Player)player, stack, slotType, renderStrings, IItemHUDProvider::addHUDStrings);
            }
            if (Mekanism.hooks.curios.isLoaded() && (inv = CuriosIntegration.getCuriosInventory((LivingEntity)player)) != null) {
                int slots = inv.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    IItemHUDProvider hudProvider = this.getHudProvider(stack);
                    if (hudProvider == null) continue;
                    count += this.makeComponent(hudProvider, (Player)player, stack, null, renderStrings, (provider, l, plyr, s, ignored) -> provider.addCurioHUDStrings(l, plyr, s));
                }
            }
            Font font = minecraft.font;
            ArrayList<DelayedString> delayedDraws = null;
            boolean reverseHud = MekanismConfig.client.reverseHUD.get();
            int maxTextHeight = graphics.guiHeight();
            if (count > 0) {
                int textWidth;
                delayedDraws = new ArrayList<DelayedString>();
                float hudScale = MekanismConfig.client.hudScale.get();
                int xScale = (int)((float)graphics.guiWidth() / hudScale);
                int yScale = (int)((float)graphics.guiHeight() / hudScale);
                int start = renderStrings.size() * 2 + count * 9;
                int y = yScale - start;
                maxTextHeight = (int)((float)y * hudScale);
                PoseStack pose = graphics.pose();
                pose.pushPose();
                pose.scale(hudScale, hudScale, hudScale);
                int backgroundColor = minecraft.options.getBackgroundColor(0.0f);
                if (backgroundColor != 0) {
                    int maxTextWidth = 0;
                    for (List list : renderStrings) {
                        for (Component text : list) {
                            textWidth = font.width((FormattedText)text);
                            if (textWidth <= maxTextWidth) continue;
                            maxTextWidth = textWidth;
                        }
                    }
                    int x = reverseHud ? xScale - maxTextWidth - 2 : 2;
                    GuiUtils.drawBackdrop(graphics, Minecraft.getInstance(), x, y, maxTextWidth, maxTextHeight, -1);
                }
                Matrix4f matrix = new Matrix4f((Matrix4fc)pose.last().pose());
                for (List list : renderStrings) {
                    for (Component text : list) {
                        textWidth = font.width((FormattedText)text);
                        int x = reverseHud ? xScale - textWidth - 2 : 2;
                        delayedDraws.add(new DelayedString(matrix, text, (float)x, (float)y, -3618616, true));
                        y += 9;
                    }
                    y += 2;
                }
                pose.popPose();
            }
            if (player.getItemBySlot(EquipmentSlot.HEAD).is(MekanismTags.Items.MEKASUIT_HUD_RENDERER)) {
                if (delayedDraws == null) {
                    delayedDraws = new ArrayList();
                }
                this.hudRenderer.renderHUD(minecraft, graphics, font, delayedDraws, delta, graphics.guiWidth(), graphics.guiHeight(), maxTextHeight, reverseHud);
            }
            if (delayedDraws != null && !delayedDraws.isEmpty()) {
                for (DelayedString delayedDraw : delayedDraws) {
                    delayedDraw.draw(graphics, font);
                }
                graphics.flush();
            }
        }
    }

    private int makeComponent(IItemHUDProvider hudProvider, Player player, ItemStack stack, EquipmentSlot slot, List<List<Component>> initial, HudComponentBuilder builder) {
        ArrayList<Component> list = new ArrayList<Component>();
        builder.add(hudProvider, list, player, stack, slot);
        int size = list.size();
        if (size > 0) {
            initial.add(list);
        }
        return size;
    }

    @FunctionalInterface
    private static interface HudComponentBuilder {
        public void add(IItemHUDProvider var1, List<Component> var2, Player var3, ItemStack var4, EquipmentSlot var5);
    }

    public record DelayedString(Matrix4f matrix, Component component, float x, float y, int color, boolean dropShadow) {
        public DelayedString(PoseStack pose, Component component, float x, float y, int color, boolean dropShadow) {
            this(new Matrix4f((Matrix4fc)pose.last().pose()), component, x, y, color, dropShadow);
        }

        public void draw(GuiGraphics graphics, Font font) {
            GuiUtils.drawStringNoFlush(graphics, this.matrix, font, this.component, this.x, this.y, this.color, this.dropShadow);
        }
    }
}

