/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.client.SpecialColors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public interface IFancyFontRenderer {
    public int getXSize();

    default public Font font() {
        return Minecraft.getInstance().font;
    }

    default public long getTimeOpened() {
        return 0L;
    }

    default public int titleTextColor() {
        return SpecialColors.TEXT_TITLE.argb();
    }

    default public int headingTextColor() {
        return SpecialColors.TEXT_HEADING.argb();
    }

    default public int subheadingTextColor() {
        return SpecialColors.TEXT_SUBHEADING.argb();
    }

    default public int screenTextColor() {
        return SpecialColors.TEXT_SCREEN.argb();
    }

    default public int activeButtonTextColor() {
        return SpecialColors.TEXT_ACTIVE_BUTTON.argb();
    }

    default public int inactiveButtonTextColor() {
        return SpecialColors.TEXT_INACTIVE_BUTTON.argb();
    }

    default public void drawTitleText(GuiGraphics graphics, Component text, int y) {
        this.drawScrollingString(graphics, text, 0, y, TextAlignment.CENTER, this.titleTextColor(), 4, false);
    }

    default public void drawTitleTextTextWithOffset(GuiGraphics graphics, Component text, int x, int y, int end) {
        this.drawTitleTextTextWithOffset(graphics, text, x, y, end, 4, TextAlignment.CENTER);
    }

    default public void drawTitleTextTextWithOffset(GuiGraphics graphics, Component text, int x, int y, int end, int maxLengthPad, TextAlignment alignment) {
        this.drawScrollingString(graphics, text, x, y, alignment, this.titleTextColor(), end - x, maxLengthPad, false);
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int maxLengthPad, boolean shadow) {
        this.drawScrollingString(graphics, text, x, y, alignment, color, maxLengthPad, shadow, this.getTimeOpened());
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int maxLengthPad, boolean shadow, long msVisible) {
        this.drawScrollingString(graphics, text, x, y, alignment, color, this.getXSize(), maxLengthPad, shadow, msVisible);
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int maxLengthPad, boolean shadow) {
        this.drawScrollingString(graphics, text, x, y, alignment, color, width, maxLengthPad, shadow, this.getTimeOpened());
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int maxLengthPad, boolean shadow, long msVisible) {
        Objects.requireNonNull(this.font());
        this.drawScrollingString(graphics, text, x, y, alignment, color, width, 9, maxLengthPad, shadow, msVisible);
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int height, int maxLengthPad, boolean shadow, long msVisible) {
        this.drawScrollingString(graphics, text, x + maxLengthPad, y, x + width - maxLengthPad, y + height, alignment, color, shadow, msVisible);
    }

    default public void drawScrollingString(GuiGraphics graphics, Component text, int minX, int minY, int maxX, int maxY, TextAlignment alignment, int color, boolean shadow, long msVisible) {
        int areaWidth;
        Font font = this.font();
        int textWidth = font.width((FormattedText)text);
        boolean isScrolling = textWidth > (areaWidth = maxX - minX);
        Objects.requireNonNull(font);
        float targetY = (float)(minY + maxY - 9) / 2.0f;
        float targetX = isScrolling ? IFancyFontRenderer.prepScrollingString(graphics, font, textWidth, areaWidth, minX, minY, maxX, maxY, Util.getMillis() - msVisible) : alignment.getTarget(font, minX, maxX, textWidth);
        graphics.drawString(font, text.getVisualOrderText(), targetX, targetY, color, shadow);
        if (isScrolling) {
            graphics.disableScissor();
        }
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int maxLengthPad, boolean shadow, float scale) {
        this.drawScaledScrollingString(graphics, text, x, y, alignment, color, maxLengthPad, shadow, scale, this.getTimeOpened());
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int maxLengthPad, boolean shadow, float scale, long msVisible) {
        this.drawScaledScrollingString(graphics, text, x, y, alignment, color, this.getXSize(), maxLengthPad, shadow, scale, msVisible);
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int maxLengthPad, boolean shadow, float scale) {
        this.drawScaledScrollingString(graphics, text, x, y, alignment, color, width, maxLengthPad, shadow, scale, this.getTimeOpened());
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int maxLengthPad, boolean shadow, float scale, long msVisible) {
        Objects.requireNonNull(this.font());
        this.drawScaledScrollingString(graphics, text, x, y, alignment, color, width, 9, maxLengthPad, shadow, scale, msVisible);
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int x, int y, TextAlignment alignment, int color, int width, int height, int maxLengthPad, boolean shadow, float scale, long msVisible) {
        this.drawScaledScrollingString(graphics, text, x + maxLengthPad, y, x + width - maxLengthPad, y + height, alignment, color, shadow, scale, msVisible);
    }

    default public void drawScaledScrollingString(GuiGraphics graphics, Component text, int minX, int minY, int maxX, int maxY, TextAlignment alignment, int color, boolean shadow, float scale, long msVisible) {
        int areaWidth;
        if (scale == 1.0f) {
            this.drawScrollingString(graphics, text, minX, minY, maxX, maxY, alignment, color, shadow, msVisible);
            return;
        }
        Font font = this.font();
        float textWidth = (float)font.width((FormattedText)text) * scale;
        boolean isScrolling = textWidth > (float)(areaWidth = maxX - minX);
        Objects.requireNonNull(font);
        float targetY = (float)(minY + maxY - 9) / 2.0f;
        float targetX = isScrolling ? IFancyFontRenderer.prepScrollingString(graphics, font, textWidth, areaWidth, minX, minY, maxX, maxY, Util.getMillis() - msVisible) : alignment.getTarget(font, minX, maxX, textWidth);
        PoseStack pose = IFancyFontRenderer.prepTextScale(graphics, font, targetX, targetY, scale);
        graphics.drawString(font, text, 0, 0, color, shadow);
        pose.popPose();
        if (isScrolling) {
            graphics.disableScissor();
        }
    }

    private static float prepScrollingString(GuiGraphics graphics, Font font, double textWidth, int areaWidth, int minX, int minY, int maxX, int maxY, long visibleDuration) {
        Matrix4f matrix4f = graphics.pose().last().pose();
        int left = (int)matrix4f.m30();
        int top = (int)matrix4f.m31();
        graphics.enableScissor(left + minX, top + minY, left + maxX, top + maxY);
        return (float)minX - (float)IFancyFontRenderer.getOverflowedBy(font, textWidth - (double)areaWidth, visibleDuration);
    }

    private static double getOverflowedBy(Font font, double overflowWidth, long visibleDuration) {
        double seconds = (double)visibleDuration / 1000.0;
        double scrollPeriod = Math.max(overflowWidth * 0.5, 3.0);
        double scrollSpeedModifier = Math.cos(Math.PI * 2 * seconds / scrollPeriod);
        if (!font.isBidirectional()) {
            scrollSpeedModifier = -scrollSpeedModifier;
        }
        double scrolledSoFar = Math.sin(1.5707963267948966 * scrollSpeedModifier) / 2.0 + 0.5;
        return scrolledSoFar * overflowWidth;
    }

    private static PoseStack prepTextScale(GuiGraphics graphics, Font font, float x, float y, float scale) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        Objects.requireNonNull(font);
        float halfLineHeight = 9.0f / 2.0f;
        float yAdd = halfLineHeight - halfLineHeight * scale;
        pose.translate(x, y + yAdd, 0.0f);
        pose.scale(scale, scale, scale);
        return pose;
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT,
        RELATIVE;


        public float getTarget(Font font, int minX, int maxX, float textWidth) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> minX;
                case 1 -> (float)minX + ((float)(maxX - minX) - textWidth) / 2.0f;
                case 2 -> (float)maxX - textWidth;
                case 3 -> font.isBidirectional() ? (float)maxX - textWidth : (float)minX;
            };
        }
    }

    public static class ReplaceableWrappedTextRenderer
    extends WrappedTextRenderer {
        public ReplaceableWrappedTextRenderer(IFancyFontRenderer parent, int width, Component text) {
            super(new SimpleFancyFontRenderer(parent.font(), width), text);
        }

        public WrappedTextRenderer replaceFont(IFancyFontRenderer font) {
            this.fontRenderer = font;
            return this;
        }

        private record SimpleFancyFontRenderer(Font font, int getXSize) implements IFancyFontRenderer
        {
        }
    }

    public static class WrappedTextRenderer {
        private final Component text;
        private List<FormattedCharSequence> linesToDraw = Collections.emptyList();
        IFancyFontRenderer fontRenderer;
        @Nullable
        private Font lastFont;
        private int lastMaxLength = -1;

        public WrappedTextRenderer(IFancyFontRenderer fontRenderer, Component text) {
            this.fontRenderer = fontRenderer;
            this.text = text;
        }

        public void render(GuiGraphics graphics, int x, int y, int maxLength, TextAlignment alignment, int color) {
            this.render(graphics, x, y, maxLength, alignment, color, 1.0f);
        }

        public int renderWithScale(GuiGraphics graphics, int x, int y, TextAlignment alignment, int color, int maxLength, float scale) {
            PoseStack pose = IFancyFontRenderer.prepTextScale(graphics, this.fontRenderer.font(), x, y, scale);
            this.render(graphics, 0, 0, maxLength, alignment, color, scale);
            pose.popPose();
            return this.linesToDraw.size();
        }

        private void render(GuiGraphics graphics, int x, int startY, int maxLength, TextAlignment alignment, int color, float scale) {
            Font font = this.fontRenderer.font();
            this.calculateLines(font, scale == 1.0f ? maxLength : Mth.floor((float)((float)maxLength / scale)));
            int maxX = x + maxLength;
            for (FormattedCharSequence line : this.linesToDraw) {
                graphics.drawString(font, line, alignment.getTarget(font, x, maxX, scale * (float)font.width(line)), (float)startY, color, false);
                Objects.requireNonNull(font);
                startY += 9;
            }
        }

        private void calculateLines(Font font, int maxLength) {
            if (font != null && (this.lastFont != font || this.lastMaxLength != maxLength)) {
                this.lastFont = font;
                this.lastMaxLength = maxLength;
                this.linesToDraw = font.split((FormattedText)this.text, maxLength);
            }
        }

        public int getRequiredHeight(int maxLength) {
            Font font = this.fontRenderer.font();
            this.calculateLines(font, maxLength);
            Objects.requireNonNull(font);
            return 9 * this.linesToDraw.size();
        }
    }
}

