/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSlot
extends GuiTexturedElement
implements IRecipeViewerGhostTarget,
ISupportsWarning<GuiSlot> {
    private static final int INVALID_SLOT_COLOR = MekanismRenderer.getColorARGB(EnumColor.DARK_RED, 0.8f);
    public static final int DEFAULT_HOVER_COLOR = -2130706433;
    private final SlotType slotType;
    private Supplier<ItemStack> validityCheck;
    private Supplier<ItemStack> storedStackSupplier;
    private Supplier<SlotOverlay> overlaySupplier;
    @Nullable
    private BooleanSupplier warningSupplier;
    @Nullable
    private IntSupplier overlayColorSupplier;
    @Nullable
    private SlotOverlay overlay;
    @Nullable
    private Function<GuiSlot, List<Component>> onHover;
    @Nullable
    private GuiElement.IClickable onClick;
    private boolean renderHover;
    private boolean renderAboveSlots;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;
    @Nullable
    private IRecipeViewerGhostTarget.IGhostIngredientConsumer ghostHandler;

    public GuiSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.slotType = type;
        this.active = false;
    }

    public GuiSlot validity(Supplier<ItemStack> validityCheck) {
        this.validityCheck = validityCheck;
        return this;
    }

    @Override
    public GuiSlot warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    public GuiSlot stored(Supplier<ItemStack> storedStackSupplier) {
        this.storedStackSupplier = storedStackSupplier;
        return this;
    }

    public GuiSlot hover(Function<GuiSlot, List<Component>> onHover) {
        this.onHover = onHover;
        return this;
    }

    public GuiSlot click(GuiElement.IClickable onClick) {
        return this.click(onClick, 0.25f, BUTTON_CLICK_SOUND);
    }

    public GuiSlot click(GuiElement.IClickable onClick, float clickVolume, @Nullable Supplier<SoundEvent> clickSound) {
        this.clickSound = clickSound;
        this.clickVolume = clickVolume;
        this.onClick = onClick;
        return this;
    }

    public GuiSlot with(SlotOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    public GuiSlot overlayColor(IntSupplier colorSupplier) {
        this.overlayColorSupplier = colorSupplier;
        return this;
    }

    public GuiSlot with(Supplier<SlotOverlay> overlaySupplier) {
        this.overlaySupplier = overlaySupplier;
        return this;
    }

    public GuiSlot setRenderHover(boolean renderHover) {
        this.renderHover = renderHover;
        return this;
    }

    public GuiSlot setGhostHandler(@Nullable IRecipeViewerGhostTarget.IGhostIngredientConsumer ghostHandler) {
        this.ghostHandler = ghostHandler;
        return this;
    }

    public GuiSlot setRenderAboveSlots() {
        this.renderAboveSlots = true;
        return this;
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.renderAboveSlots) {
            this.draw(guiGraphics);
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.renderAboveSlots) {
            this.draw(guiGraphics);
        }
    }

    private void draw(@NotNull GuiGraphics guiGraphics) {
        ResourceLocation texture = this.warningSupplier != null && this.warningSupplier.getAsBoolean() ? this.slotType.getWarningTexture() : this.getResource();
        guiGraphics.blit(texture, this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (this.overlaySupplier != null) {
            this.overlay = this.overlaySupplier.get();
        }
        if (this.overlay != null) {
            guiGraphics.blit(this.overlay.getTexture(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.overlay.getWidth(), this.overlay.getHeight(), this.overlay.getWidth(), this.overlay.getHeight());
        }
        this.drawContents(guiGraphics);
    }

    protected void drawContents(@NotNull GuiGraphics guiGraphics) {
        ItemStack stored;
        if (this.validityCheck != null) {
            ItemStack invalid = this.validityCheck.get();
            if (!invalid.isEmpty()) {
                int xPos = this.relativeX + 1;
                int yPos = this.relativeY + 1;
                guiGraphics.fill(xPos, yPos, xPos + 16, yPos + 16, INVALID_SLOT_COLOR);
                this.gui().renderItem(guiGraphics, invalid, xPos, yPos);
            }
        } else if (this.storedStackSupplier != null && !(stored = this.storedStackSupplier.get()).isEmpty()) {
            this.gui().renderItem(guiGraphics, stored, this.relativeX + 1, this.relativeY + 1);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int yPos;
        int xPos;
        boolean hovered = this.checkWindows(mouseX, mouseY, this.isHovered());
        if (this.renderHover && hovered) {
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos, xPos + 16, yPos + 16, -2130706433);
        }
        if (this.overlayColorSupplier != null) {
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos, xPos + 16, yPos + 16, this.overlayColorSupplier.getAsInt());
        }
        if (hovered) {
            this.renderToolTip(guiGraphics, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        GuiMekanismTile gui;
        IGuiWrapper iGuiWrapper;
        ItemStack stack = this.gui().getCarriedItem();
        List<Component> list = Collections.emptyList();
        if (this.onHover != null) {
            list = this.onHover.apply(this);
        }
        if (list.isEmpty() && !stack.isEmpty() && stack.getItem() instanceof ItemConfigurator && (iGuiWrapper = this.gui()) instanceof GuiMekanismTile && (iGuiWrapper = (gui = (GuiMekanismTile)iGuiWrapper).getTileEntity()) instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)iGuiWrapper);
            iGuiWrapper = gui.getSlotUnderMouse();
            if (iGuiWrapper instanceof InventoryContainerSlot) {
                InventoryContainerSlot slot = (InventoryContainerSlot)((Object)iGuiWrapper);
                ConfigInfo info = config.getConfig().getConfig(TransmissionType.ITEM);
                if (info != null) {
                    IInventorySlot inventorySlot = slot.getInventorySlot();
                    for (DataType type : info.getSupportedDataTypes()) {
                        InventorySlotInfo slotInfo;
                        ISlotInfo iSlotInfo = info.getSlotInfo(type);
                        if (!(iSlotInfo instanceof InventorySlotInfo) || !(slotInfo = (InventorySlotInfo)iSlotInfo).hasSlot(inventorySlot)) continue;
                        EnumColor color = type.getColor();
                        list = List.of(MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, type, color.getName()));
                        break;
                    }
                }
            }
        }
        if (!list.equals(this.lastInfo)) {
            this.lastInfo = list;
            this.lastTooltip = TooltipUtils.create(list);
        }
        this.setTooltip(this.lastTooltip);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.onClick != null && this.isValidClickButton(button) && mouseX >= (double)(this.getX() + this.borderSize()) && mouseY >= (double)(this.getY() + this.borderSize()) && mouseX < (double)(this.getRight() - this.borderSize()) && mouseY < (double)(this.getBottom() - this.borderSize()) && this.onClick.onClick(this, mouseX, mouseY)) {
            this.playDownSound(minecraft.getSoundManager());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public IRecipeViewerGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return this.ghostHandler;
    }

    @Override
    public int borderSize() {
        return 1;
    }
}

