/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDigitalBar;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuiQIOFrequencyDataScreen
extends GuiInnerScreen {
    private final Supplier<QIOFrequency> frequencySupplier;

    public GuiQIOFrequencyDataScreen(IGuiWrapper gui, int x, int y, int width, int height, final Supplier<QIOFrequency> frequencySupplier) {
        super(gui, x, y, width, height);
        this.frequencySupplier = frequencySupplier;
        this.active = true;
        this.addChild(new GuiDigitalBar(gui, new GuiBar.IBarInfoHandler(){

            @Override
            public double getLevel() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? 0.0 : (double)freq.getTotalItemCount() / (double)freq.getTotalItemCountCapacity();
            }

            @Override
            public Component getTooltip() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? null : MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity()));
            }
        }, this.relativeX + 11, this.relativeY + 20, 50));
        this.addChild(new GuiDigitalBar(gui, new GuiBar.IBarInfoHandler(){

            @Override
            public double getLevel() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? 0.0 : (double)freq.getTotalItemTypes(true) / (double)freq.getTotalItemTypeCapacity();
            }

            @Override
            public Component getTooltip() {
                QIOFrequency freq = (QIOFrequency)frequencySupplier.get();
                return freq == null ? null : MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity()));
            }
        }, this.relativeX + 83, this.relativeY + 20, 50));
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        QIOFrequency freq = this.frequencySupplier.get();
        if (freq != null) {
            this.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.FREQUENCY.translate(freq.getName()), 0, 5, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), 5, false, 0.8f);
        }
        this.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.QIO_ITEMS.translate(), 11, 32, IFancyFontRenderer.TextAlignment.CENTER, this.screenTextColor(), 50, 0, false, 0.8f);
        this.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.QIO_TYPES.translate(), 83, 32, IFancyFontRenderer.TextAlignment.CENTER, this.screenTextColor(), 50, 0, false, 0.8f);
    }
}

