/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Collections;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class GuiScreenSwitch
extends GuiInnerScreen {
    private final BooleanSupplier stateSupplier;
    private final GuiElement.IClickable onToggle;

    public GuiScreenSwitch(IGuiWrapper gui, int x, int y, int width, Component buttonName, BooleanSupplier stateSupplier, GuiElement.IClickable onToggle) {
        super(gui, x, y, width, 22, () -> Collections.singletonList(buttonName));
        this.stateSupplier = stateSupplier;
        this.onToggle = onToggle;
        this.active = true;
        this.clickSound = () -> this.stateSupplier.getAsBoolean() ? (SoundEvent)MekanismSounds.BEEP_OFF.get() : (SoundEvent)MekanismSounds.BEEP_ON.get();
        this.clickVolume = 1.0f;
        this.padding(4);
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int buttonSizeX = 15;
        int buttonSizeY = 8;
        int buttonXOffset = this.width - 2 - buttonSizeX;
        guiGraphics.blit(GuiDigitalSwitch.SWITCH, this.relativeX + buttonXOffset, this.relativeY + 2, 0.0f, this.stateSupplier.getAsBoolean() ? 0.0f : (float)buttonSizeY, buttonSizeX, buttonSizeY, buttonSizeX, buttonSizeY * 2);
        guiGraphics.blit(GuiDigitalSwitch.SWITCH, this.relativeX + buttonXOffset, this.relativeY + 2 + buttonSizeY + 1, 0.0f, this.stateSupplier.getAsBoolean() ? (float)buttonSizeY : 0.0f, buttonSizeX, buttonSizeY, buttonSizeX, buttonSizeY * 2);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        int buttonSizeX = 15;
        int buttonXOffset = this.width - 2 - buttonSizeX;
        this.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.ON.translate(), buttonXOffset, 2, IFancyFontRenderer.TextAlignment.CENTER, 0x101010, buttonSizeX, 1, false, 0.5f);
        this.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.OFF.translate(), buttonXOffset, 11, IFancyFontRenderer.TextAlignment.CENTER, 0x101010, buttonSizeX, 1, false, 0.5f);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.onToggle.onClick(this, mouseX, mouseY);
    }

    @Override
    protected int getMaxTextWidth(int row) {
        return super.getMaxTextWidth(row) - 2 - 15;
    }
}

