/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.InputIngredient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class ItemStackIngredient
implements InputIngredient<ItemStack> {
    public static final Codec<ItemStackIngredient> CODEC = SizedIngredient.FLAT_CODEC.xmap(ItemStackIngredient::new, ItemStackIngredient::ingredient);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackIngredient> STREAM_CODEC = SizedIngredient.STREAM_CODEC.map(ItemStackIngredient::new, ItemStackIngredient::ingredient);
    private final SizedIngredient ingredient;
    @Nullable
    private List<ItemStack> representations;

    public static ItemStackIngredient of(SizedIngredient ingredient) {
        Objects.requireNonNull(ingredient, "ItemStackIngredients cannot be created from a null ingredient.");
        if (ingredient.ingredient().isEmpty()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created using the empty ingredient.");
        }
        return new ItemStackIngredient(ingredient);
    }

    private ItemStackIngredient(SizedIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public boolean test(ItemStack stack) {
        Objects.requireNonNull(stack);
        return this.ingredient.test(stack);
    }

    @Override
    public boolean testType(ItemStack stack) {
        Objects.requireNonNull(stack);
        return this.ingredient.ingredient().test(stack);
    }

    @Override
    public ItemStack getMatchingInstance(ItemStack stack) {
        return this.test(stack) ? stack.copyWithCount(this.ingredient.count()) : ItemStack.EMPTY;
    }

    @Override
    public long getNeededAmount(ItemStack stack) {
        return this.testType(stack) ? (long)this.ingredient.count() : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.ingredient.ingredient().hasNoItems();
    }

    @Override
    public void logMissingTags() {
        if (this.hasNoMatchingInstances()) {
            Ingredient unsized = this.ingredient.ingredient();
            if (unsized.isSimple()) {
                if (unsized.isEmpty()) {
                    MekanismAPI.logger.error("Empty ingredient: {}", (Object)unsized);
                } else {
                    for (Ingredient.Value ingredientValue : unsized.getValues()) {
                        if (ingredientValue instanceof Ingredient.TagValue) {
                            Ingredient.TagValue tagValue = (Ingredient.TagValue)ingredientValue;
                            MekanismAPI.logger.error("Empty tag: {}", (Object)tagValue);
                            continue;
                        }
                        MekanismAPI.logger.warn("Unknown value: {}", (Object)ingredientValue);
                    }
                }
            } else {
                MekanismAPI.logger.error("Empty ItemStackIngredient: {}", (Object)SerializerHelper.stringify(Ingredient.CODEC, unsized));
            }
        }
    }

    @Override
    public List<@NotNull ItemStack> getRepresentations() {
        if (this.representations == null) {
            this.representations = List.of(this.ingredient.getItems());
        }
        return this.representations;
    }

    @ApiStatus.Internal
    public SizedIngredient ingredient() {
        return this.ingredient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ingredient.equals((Object)((ItemStackIngredient)o).ingredient);
    }

    public int hashCode() {
        return this.ingredient.hashCode();
    }

    public String toString() {
        return this.ingredient.toString();
    }
}

