/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.fluid;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.ExtendedFluidHandlerUtils;
import mekanism.api.fluid.IExtendedFluidHandler;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ISidedFluidHandler
extends IExtendedFluidHandler {
    @Nullable
    default public Direction getFluidSideFor() {
        return null;
    }

    public int getTanks(@Nullable Direction var1);

    default public int getTanks() {
        return this.getTanks(this.getFluidSideFor());
    }

    public FluidStack getFluidInTank(int var1, @Nullable Direction var2);

    default public FluidStack getFluidInTank(int tank) {
        return this.getFluidInTank(tank, this.getFluidSideFor());
    }

    public void setFluidInTank(int var1, FluidStack var2, @Nullable Direction var3);

    @Override
    default public void setFluidInTank(int tank, FluidStack stack) {
        this.setFluidInTank(tank, stack, this.getFluidSideFor());
    }

    public int getTankCapacity(int var1, @Nullable Direction var2);

    default public int getTankCapacity(int tank) {
        return this.getTankCapacity(tank, this.getFluidSideFor());
    }

    public boolean isFluidValid(int var1, FluidStack var2, @Nullable Direction var3);

    default public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isFluidValid(tank, stack, this.getFluidSideFor());
    }

    public FluidStack insertFluid(int var1, FluidStack var2, @Nullable Direction var3, Action var4);

    @Override
    default public FluidStack insertFluid(int tank, FluidStack stack, Action action) {
        return this.insertFluid(tank, stack, this.getFluidSideFor(), action);
    }

    public FluidStack extractFluid(int var1, int var2, @Nullable Direction var3, Action var4);

    @Override
    default public FluidStack extractFluid(int tank, int amount, Action action) {
        return this.extractFluid(tank, amount, this.getFluidSideFor(), action);
    }

    default public FluidStack insertFluid(FluidStack stack, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.insert(stack, side, action, this::getTanks, this::getFluidInTank, this::insertFluid);
    }

    default public FluidStack extractFluid(int amount, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.extract(amount, side, action, this::getTanks, this::getFluidInTank, this::extractFluid);
    }

    default public FluidStack extractFluid(FluidStack stack, @Nullable Direction side, Action action) {
        return ExtendedFluidHandlerUtils.extract(stack, side, action, this::getTanks, this::getFluidInTank, this::extractFluid);
    }
}

