/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Range;

@NothingNullByDefault
public interface IEnergyContainer
extends INBTSerializable<CompoundTag>,
IContentsListener {
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEnergy();

    public void setEnergy(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long var1);

    default public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long insert(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long amount, Action action, AutomationType automationType) {
        if (amount <= 0L) {
            return amount;
        }
        long needed = this.getNeeded();
        if (needed == 0L) {
            return amount;
        }
        long toAdd = Math.min(amount, needed);
        if (action.execute()) {
            this.setEnergy(this.getEnergy() + toAdd);
        }
        return amount - toAdd;
    }

    default public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long extract(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount <= 0L) {
            return 0L;
        }
        long ret = Math.min(this.getEnergy(), amount);
        if (ret > 0L && action.execute()) {
            this.setEnergy(this.getEnergy() - ret);
        }
        return ret;
    }

    public long getMaxEnergy();

    default public boolean isEmpty() {
        return this.getEnergy() == 0L;
    }

    default public void setEmpty() {
        this.setEnergy(0L);
    }

    default public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getNeeded() {
        return this.getMaxEnergy() - this.getEnergy();
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.putLong("stored", this.getEnergy());
        }
        return nbt;
    }
}

