/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.ChemicalSolidTag;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class Chemical
implements IChemicalProvider,
IChemicalAttributeContainer<Chemical> {
    @Deprecated(forRemoval=true, since="!0.7.11")
    public static final Codec<Chemical> CODEC = MekanismAPI.CHEMICAL_REGISTRY.byNameCodec();
    public static final Codec<Holder<Chemical>> HOLDER_CODEC = MekanismAPI.CHEMICAL_REGISTRY.holderByNameCodec();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final StreamCodec<RegistryFriendlyByteBuf, Chemical> STREAM_CODEC = ByteBufCodecs.registry(MekanismAPI.CHEMICAL_REGISTRY_NAME);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Chemical>> HOLDER_STREAM_CODEC = ByteBufCodecs.holderRegistry(MekanismAPI.CHEMICAL_REGISTRY_NAME);
    private final Holder.Reference<Chemical> builtInRegistryHolder = MekanismAPI.CHEMICAL_REGISTRY.createIntrusiveHolder((Object)this);
    private final List<IChemicalAttribute> attributes = new ArrayList<IChemicalAttribute>();
    private final List<IChemicalAttribute> attributesView = Collections.unmodifiableList(this.attributes);
    private final ResourceLocation iconLocation;
    private final int tint;
    private double radioactivity;
    private boolean hasAttributesWithValidation;
    @Nullable
    private String translationKey;
    @Deprecated(forRemoval=true, since="10.7.11")
    private Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> legacyAttributeMap;
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    private Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    @Deprecated(forRemoval=true, since="10.7.11")
    private double legacyRadioactivity;
    @Deprecated(forRemoval=true, since="10.7.11")
    private boolean hasLegacyAttributesWithValidation;
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    private TagKey<Item> legacyOreTag;
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    private TagKey<Item> oreTag;
    @Deprecated(forRemoval=true, since="10.7.11")
    private boolean isGaseous;

    @Deprecated(forRemoval=true, since="10.7.11")
    public static Optional<Chemical> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid chemical: '{}'", error));
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static Chemical parseOptional(HolderLookup.Provider lookupProvider, String tag) {
        return (Chemical)Chemical.parseOptionalHolder(lookupProvider, tag).value();
    }

    public static Optional<Holder<Chemical>> parseHolder(HolderLookup.Provider lookupProvider, Tag tag) {
        return HOLDER_CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid chemical: '{}'", error));
    }

    public static Holder<Chemical> parseOptionalHolder(HolderLookup.Provider lookupProvider, String tag) {
        Optional chemicalReference;
        ResourceLocation rl;
        if (tag.isEmpty()) {
            return MekanismAPI.EMPTY_CHEMICAL_HOLDER;
        }
        Optional chemicalLookup = lookupProvider.lookup(MekanismAPI.CHEMICAL_REGISTRY_NAME);
        if (chemicalLookup.isPresent() && (rl = ResourceLocation.tryParse((String)tag)) != null && (chemicalReference = ((HolderLookup.RegistryLookup)chemicalLookup.get()).get(ResourceKey.create(MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)rl))).isPresent()) {
            return (Holder)chemicalReference.get();
        }
        return MekanismAPI.EMPTY_CHEMICAL_HOLDER;
    }

    public Chemical(ChemicalBuilder builder) {
        this.iconLocation = builder.getTexture();
        this.tint = builder.getTint();
        this.initLegacy(builder);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    private void initLegacy(ChemicalBuilder builder) {
        this.legacyAttributeMap = new HashMap<Class<? extends ChemicalAttribute>, ChemicalAttribute>(builder.getAttributeMap());
        for (ChemicalAttribute legacyAttribute : this.legacyAttributeMap.values()) {
            if (legacyAttribute instanceof ChemicalAttributes.Radiation) {
                ChemicalAttributes.Radiation radiation = (ChemicalAttributes.Radiation)legacyAttribute;
                this.radioactivity = this.legacyRadioactivity = radiation.getRadioactivity();
                continue;
            }
            if (!legacyAttribute.needsValidation()) continue;
            this.hasLegacyAttributesWithValidation = true;
            this.hasAttributesWithValidation = true;
        }
        this.legacyOreTag = builder.getOreTag();
        this.oreTag = this.legacyOreTag;
        this.isGaseous = builder.isGaseous();
    }

    public final String toString() {
        return MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)this).getRegisteredName();
    }

    @Override
    @NotNull
    public final Chemical getChemical() {
        return this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeDescriptionId((String)"chemical", (ResourceLocation)MekanismAPI.CHEMICAL_REGISTRY.getKeyOrNull((Object)this));
        }
        return this.translationKey;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    private Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> getAllAttributes() {
        if (this.attributes.isEmpty()) {
            return this.legacyAttributeMap;
        }
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<Class<? extends ChemicalAttribute>, ChemicalAttribute>(this.legacyAttributeMap);
            for (IChemicalAttribute attribute : this.attributes) {
                ChemicalAttribute legacyAttribute = attribute.toLegacyAttribute();
                this.attributeMap.put(legacyAttribute.getClass(), legacyAttribute);
            }
        }
        return this.attributeMap;
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.getAllAttributes().containsKey(type);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean hasLegacy(Class<? extends ChemicalAttribute> type) {
        return this.legacyAttributeMap.containsKey(type);
    }

    public boolean isRadioactive() {
        return this.radioactivity > 0.0;
    }

    public double getRadioactivity() {
        return this.radioactivity;
    }

    public boolean hasAttributesWithValidation() {
        return this.hasAttributesWithValidation || this.isRadioactive() && IRadiationManager.INSTANCE.isRadiationEnabled();
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return (ATTRIBUTE)this.getAllAttributes().get(type);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE getLegacy(Class<ATTRIBUTE> type) {
        return (ATTRIBUTE)this.legacyAttributeMap.get(type);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public void addAttribute(ChemicalAttribute attribute) {
        this.legacyAttributeMap.put(attribute.getClass(), attribute);
        this.attributeMap = null;
        if (attribute instanceof ChemicalAttributes.Radiation) {
            ChemicalAttributes.Radiation radiation = (ChemicalAttributes.Radiation)attribute;
            this.radioactivity = this.legacyRadioactivity = radiation.getRadioactivity();
        } else if (attribute.needsValidation()) {
            this.hasLegacyAttributesWithValidation = true;
            this.hasAttributesWithValidation = true;
        }
    }

    public List<IChemicalAttribute> getModernAttributes() {
        return this.attributesView;
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public Collection<ChemicalAttribute> getAttributes() {
        return this.getAllAttributes().values();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public Collection<ChemicalAttribute> getLegacyAttributes() {
        return this.getAttributes();
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.getAllAttributes().keySet();
    }

    @Override
    public Component getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey());
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public int getColorRepresentation() {
        return this.getTint();
    }

    @Deprecated(forRemoval=true, since="10.7.9")
    public boolean is(TagKey<Chemical> tag) {
        return this.getAsHolder().is(tag);
    }

    @Deprecated(forRemoval=true, since="10.7.9")
    public Stream<TagKey<Chemical>> getTags() {
        return this.getAsHolder().tags();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public Holder<Chemical> getAsHolder() {
        return this.builtInRegistryHolder;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_CHEMICAL;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    public TagKey<Item> getOreTag() {
        return this.oreTag;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean isGaseous() {
        return this.isGaseousLegacy() || this.is(MekanismAPITags.Chemicals.GASEOUS);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean isGaseousLegacy() {
        return this.isGaseous;
    }

    @ApiStatus.Internal
    @MustBeInvokedByOverriders
    public void updateFromDataMap(Holder<Chemical> holder) {
        ChemicalSolidTag tag = (ChemicalSolidTag)holder.getData(IMekanismDataMapTypes.INSTANCE.chemicalSolidTag());
        this.oreTag = tag == null ? this.legacyOreTag : tag.solidRepresentation();
        this.attributeMap = null;
        this.hasAttributesWithValidation = this.hasLegacyAttributesWithValidation;
        this.radioactivity = this.legacyRadioactivity;
        this.attributes.clear();
        this.trackAttribute(holder, IMekanismDataMapTypes.INSTANCE.chemicalFuel());
        this.trackAttribute(holder, IMekanismDataMapTypes.INSTANCE.chemicalRadioactivity());
        this.trackAttribute(holder, IMekanismDataMapTypes.INSTANCE.cooledChemicalCoolant());
        this.trackAttribute(holder, IMekanismDataMapTypes.INSTANCE.heatedChemicalCoolant());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void trackAttribute(Holder<Chemical> holder, DataMapType<Chemical, ? extends IChemicalAttribute> dataMapType) {
        IChemicalAttribute attribute = (IChemicalAttribute)holder.getData(dataMapType);
        if (attribute == null) return;
        this.attributes.add(attribute);
        if (!(attribute instanceof ChemicalRadioactivity)) {
            this.hasAttributesWithValidation |= attribute.needsValidation();
            return;
        }
        ChemicalRadioactivity chemicalRadioactivity = (ChemicalRadioactivity)attribute;
        try {
            double d;
            double rads;
            this.radioactivity = rads = (d = chemicalRadioactivity.radioactivity());
            return;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmptyType()) {
            throw new IllegalStateException("Cannot encode empty Chemical");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmptyType() ? new CompoundTag() : this.save(lookupProvider);
    }

    protected void appendHoverText(ChemicalStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        for (IChemicalAttribute attribute : this.attributes) {
            attribute.collectTooltips(context, tooltips, tooltipFlag);
        }
        if (!this.legacyAttributeMap.isEmpty()) {
            Consumer<Component> tooltipAdder = tooltips::add;
            for (ChemicalAttribute attr : this.getLegacyAttributes()) {
                attr.collectTooltips(tooltipAdder);
            }
        }
    }
}

