/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicChemicalTank
implements IChemicalTank,
IChemicalHandler {
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final Predicate<Chemical> alwaysTrue = ConstantPredicates.alwaysTrue();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final Predicate<Chemical> alwaysFalse = ConstantPredicates.alwaysFalse();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final BiPredicate<Chemical, @NotNull AutomationType> alwaysTrueBi = ConstantPredicates.alwaysTrueBi();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final BiPredicate<Chemical, @NotNull AutomationType> internalOnly = ConstantPredicates.internalOnly();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final BiPredicate<Chemical, @NotNull AutomationType> notExternal = ConstantPredicates.notExternal();
    @Deprecated(forRemoval=true, since="10.7.11")
    public static final BiPredicate<Chemical, @NotNull AutomationType> manualOnly = ConstantPredicates.manualOnly();
    private final Predicate<ChemicalStack> validator;
    protected final BiPredicate<ChemicalStack, @NotNull AutomationType> canExtractModern;
    protected final BiPredicate<ChemicalStack, @NotNull AutomationType> canInsertModern;
    @Deprecated(forRemoval=true, since="10.7.11")
    protected final BiPredicate<Chemical, @NotNull AutomationType> canExtract;
    @Deprecated(forRemoval=true, since="10.7.11")
    protected final BiPredicate<Chemical, @NotNull AutomationType> canInsert;
    @Nullable
    private final ChemicalAttributeValidator attributeValidator;
    private final long capacity;
    protected ChemicalStack stored;
    @Nullable
    private final IContentsListener listener;

    public static IChemicalTank create(long capacity, @Nullable IContentsListener listener) {
        return BasicChemicalTank.createWithValidator(capacity, null, listener);
    }

    public static IChemicalTank createWithValidator(long capacity, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicChemicalTank(capacity, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), attributeValidator, listener, null);
    }

    public static IChemicalTank createAllValid(long capacity, @Nullable IContentsListener listener) {
        return BasicChemicalTank.createWithValidator(capacity, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, Predicate<Chemical> canExtract, Predicate<Chemical> canInsert, @Nullable IContentsListener listener) {
        return BasicChemicalTank.create(capacity, canExtract, canInsert, alwaysTrue, listener);
    }

    public static IChemicalTank createModern(long capacity, Predicate<ChemicalStack> canExtract, Predicate<ChemicalStack> canInsert, @Nullable IContentsListener listener) {
        return BasicChemicalTank.createModern(capacity, canExtract, canInsert, ConstantPredicates.alwaysTrue(), listener);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, alwaysTrueBi, alwaysTrueBi, validator, null, listener);
    }

    public static IChemicalTank createModern(long capacity, Predicate<ChemicalStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), validator, null, listener, null);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank input(long capacity, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, notExternal, alwaysTrueBi, validator, null, listener);
    }

    public static IChemicalTank inputModern(long capacity, Predicate<ChemicalStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, ConstantPredicates.notExternal(), ConstantPredicates.alwaysTrueBi(), validator, null, listener, null);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank input(long capacity, Predicate<Chemical> canInsert, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, notExternal, (stack, automationType) -> canInsert.test((Chemical)stack), validator, null, listener);
    }

    public static IChemicalTank inputModern(long capacity, Predicate<ChemicalStack> canInsert, Predicate<ChemicalStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, ConstantPredicates.notExternal(), (stack, automationType) -> canInsert.test((ChemicalStack)stack), validator, null, listener, null);
    }

    public static IChemicalTank output(long capacity, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicChemicalTank(capacity, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.internalOnly(), ConstantPredicates.alwaysTrue(), ChemicalAttributeValidator.ALWAYS_ALLOW, listener, null);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, Predicate<Chemical> canExtract, Predicate<Chemical> canInsert, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return BasicChemicalTank.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public static IChemicalTank createModern(long capacity, Predicate<ChemicalStack> canExtract, Predicate<ChemicalStack> canInsert, Predicate<ChemicalStack> validator, @Nullable IContentsListener listener) {
        return BasicChemicalTank.createModern(capacity, canExtract, canInsert, validator, null, listener);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable IContentsListener listener) {
        return BasicChemicalTank.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public static IChemicalTank createModern(long capacity, BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract, BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert, Predicate<ChemicalStack> validator, @Nullable IContentsListener listener) {
        return BasicChemicalTank.createModern(capacity, canExtract, canInsert, validator, null, listener);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, Predicate<Chemical> canExtract, Predicate<Chemical> canInsert, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, (stack, automationType) -> automationType == AutomationType.MANUAL || canExtract.test((Chemical)stack), (stack, automationType) -> canInsert.test((Chemical)stack), validator, attributeValidator, listener);
    }

    public static IChemicalTank createModern(long capacity, Predicate<ChemicalStack> canExtract, Predicate<ChemicalStack> canInsert, Predicate<ChemicalStack> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, (stack, automationType) -> automationType == AutomationType.MANUAL || canExtract.test((ChemicalStack)stack), (stack, automationType) -> canInsert.test((ChemicalStack)stack), validator, attributeValidator, listener, null);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static IChemicalTank create(long capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    public static IChemicalTank createModern(long capacity, BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract, BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert, Predicate<ChemicalStack> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return new BasicChemicalTank(capacity, canExtract, canInsert, validator, attributeValidator, listener, null);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    private static BiPredicate<Chemical, @NotNull AutomationType> wrapAutomationPredicate(BiPredicate<ChemicalStack, @NotNull AutomationType> predicate) {
        if (predicate == ConstantPredicates.alwaysTrueBi() || predicate == ConstantPredicates.internalOnly() || predicate == ConstantPredicates.notExternal() || predicate == ConstantPredicates.manualOnly()) {
            return predicate;
        }
        return (chemical, automationType) -> predicate.test(new ChemicalStack((Chemical)chemical, 1L), (AutomationType)((Object)automationType));
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    private static BiPredicate<ChemicalStack, @NotNull AutomationType> wrapAutomationPredicateToModern(BiPredicate<Chemical, @NotNull AutomationType> predicate) {
        if (predicate == alwaysTrueBi || predicate == internalOnly || predicate == notExternal || predicate == manualOnly) {
            return predicate;
        }
        return (chemical, automationType) -> predicate.test(chemical.getChemical(), (AutomationType)((Object)automationType));
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    protected BasicChemicalTank(long capacity, BiPredicate<Chemical, @NotNull AutomationType> canExtract, BiPredicate<Chemical, @NotNull AutomationType> canInsert, Predicate<Chemical> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        this.capacity = capacity;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.canExtractModern = BasicChemicalTank.wrapAutomationPredicateToModern(canExtract);
        this.canInsertModern = BasicChemicalTank.wrapAutomationPredicateToModern(canInsert);
        this.validator = validator == alwaysTrue || validator == alwaysFalse ? validator : chemical -> validator.test(chemical.getChemical());
        this.attributeValidator = attributeValidator;
        this.listener = listener;
        this.stored = ChemicalStack.EMPTY;
    }

    protected BasicChemicalTank(long capacity, BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract, BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert, Predicate<ChemicalStack> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener, @Nullable Void ignored) {
        this.capacity = capacity;
        this.canExtractModern = canExtract;
        this.canInsertModern = canInsert;
        this.validator = validator;
        this.attributeValidator = attributeValidator;
        this.listener = listener;
        this.stored = ChemicalStack.EMPTY;
        this.canExtract = BasicChemicalTank.wrapAutomationPredicate(this.canExtractModern);
        this.canInsert = BasicChemicalTank.wrapAutomationPredicate(this.canInsertModern);
    }

    @Override
    public ChemicalStack getStack() {
        return this.stored;
    }

    @Override
    public void setStack(ChemicalStack stack) {
        this.setStack(stack, true);
    }

    protected long getInsertRate(@Nullable AutomationType automationType) {
        return Long.MAX_VALUE;
    }

    protected long getExtractRate(@Nullable AutomationType automationType) {
        return Long.MAX_VALUE;
    }

    @Override
    public void setStackUnchecked(ChemicalStack stack) {
        this.setStack(stack, false);
    }

    private void setStack(ChemicalStack stack, boolean validateStack) {
        if (stack.isEmpty()) {
            if (this.stored.isEmpty()) {
                return;
            }
            this.stored = ChemicalStack.EMPTY;
        } else if (!validateStack || this.isValid(stack)) {
            this.stored = stack.copy();
        } else {
            throw new RuntimeException("Invalid chemical for tank: " + String.valueOf(stack));
        }
        this.onContentsChanged();
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        boolean sameType = false;
        if (stack.isEmpty() || !this.isEmpty() && !(sameType = this.isTypeEqual(stack))) {
            return stack;
        }
        long needed = Math.min(this.getInsertRate(automationType), this.getNeeded());
        if (needed <= 0L) {
            return stack;
        }
        if (!this.isValid(stack) || !this.canInsertModern.test(stack, automationType)) {
            return stack;
        }
        long toAdd = Math.min(stack.getAmount(), needed);
        if (action.execute()) {
            if (sameType) {
                this.stored.grow(toAdd);
                this.onContentsChanged();
            } else {
                this.setStackUnchecked(stack.copyWithAmount(toAdd));
            }
        }
        return stack.copyWithAmount(stack.getAmount() - toAdd);
    }

    @Override
    public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1L || !this.canExtractModern.test(this.stored, automationType)) {
            return ChemicalStack.EMPTY;
        }
        long size = Math.min(Math.min(this.getExtractRate(automationType), this.getStored()), amount);
        if (size == 0L) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack ret = this.stored.copyWithAmount(size);
        if (!ret.isEmpty() && action.execute()) {
            this.stored.shrink(ret.getAmount());
            this.onContentsChanged();
        }
        return ret;
    }

    @Override
    public boolean isValid(ChemicalStack stack) {
        return this.getAttributeValidator().process(stack) && this.validator.test(stack);
    }

    @Override
    public long setStackSize(long amount, Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        this.stored.setAmount(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public long growStack(long amount, Action action) {
        long current = this.getStored();
        if (current == 0L) {
            return 0L;
        }
        if (amount > 0L) {
            amount = Math.min(Math.min(amount, this.getNeeded()), this.getInsertRate(null));
        } else if (amount < 0L) {
            amount = Math.max(amount, -this.getExtractRate(null));
        }
        long newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    @Override
    public long getStored() {
        return this.stored.getAmount();
    }

    @Override
    public Holder<Chemical> getTypeHolder() {
        return this.stored.getChemicalHolder();
    }

    @Override
    public boolean isTypeEqual(ChemicalStack other) {
        return ChemicalStack.isSameChemical(this.stored, other);
    }

    @Override
    public boolean isTypeEqual(Holder<Chemical> holder) {
        return this.stored.is(holder);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public ChemicalAttributeValidator getAttributeValidator() {
        return this.attributeValidator == null ? IChemicalTank.super.getAttributeValidator() : this.attributeValidator;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("stored", this.stored.save(provider));
        }
        return nbt;
    }

    @Override
    public int getChemicalTanks() {
        return 1;
    }

    @Override
    public ChemicalStack getChemicalInTank(int tank) {
        return tank == 0 ? this.getStack() : ChemicalStack.EMPTY;
    }

    @Override
    public void setChemicalInTank(int tank, ChemicalStack stack) {
        if (tank == 0) {
            this.setStack(stack);
        }
    }

    @Override
    public long getChemicalTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0L;
    }

    @Override
    public boolean isValid(int tank, ChemicalStack stack) {
        return tank == 0 && this.isValid(stack);
    }

    @Override
    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        return tank == 0 ? this.insertChemical(stack, action) : stack;
    }

    @Override
    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        return this.insert(stack, action, AutomationType.EXTERNAL);
    }

    @Override
    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        return tank == 0 ? this.extractChemical(amount, action) : ChemicalStack.EMPTY;
    }

    @Override
    public ChemicalStack extractChemical(long amount, Action action) {
        return this.extract(amount, action, AutomationType.EXTERNAL);
    }

    @Override
    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return this.isTypeEqual(stack) ? this.extractChemical(stack.getAmount(), action) : ChemicalStack.EMPTY;
    }
}

