/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;

@NothingNullByDefault
public class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static void readContents(HolderLookup.Provider provider, List<? extends INBTSerializable<CompoundTag>> contents, ListTag storedContents, String key) {
        int size = contents.size();
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            CompoundTag tagCompound = storedContents.getCompound(tagCount);
            byte id = tagCompound.getByte(key);
            if (id < 0 || id >= size) continue;
            contents.get(id).deserializeNBT(provider, (Tag)tagCompound);
        }
    }

    public static ListTag writeContents(HolderLookup.Provider provider, List<? extends INBTSerializable<CompoundTag>> contents, String key) {
        ListTag storedContents = new ListTag();
        for (int tank = 0; tank < contents.size(); ++tank) {
            CompoundTag tagCompound = (CompoundTag)contents.get(tank).serializeNBT(provider);
            if (tagCompound.isEmpty()) continue;
            tagCompound.putByte(key, (byte)tank);
            storedContents.add((Object)tagCompound);
        }
        return storedContents;
    }
}

