/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.network.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.client.ClientHooks;

public class ClientHandlers {
    public static void handleCloseCart(int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as level is null.");
            return;
        }
        Entity cart = level.getEntity(entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as entity is null.");
            return;
        }
        ILootrCart iLootrCart = LootrAPI.resolveEntity(cart);
        if (iLootrCart instanceof ILootrCart) {
            ILootrCart lootrCart = iLootrCart;
            lootrCart.setClientOpened(false);
            return;
        }
        LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as entity is not a Lootr-compatible entity.");
    }

    public static void handleOpenCart(int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as level is null.");
            return;
        }
        Entity cart = level.getEntity(entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as entity is null.");
            return;
        }
        ILootrCart iLootrCart = LootrAPI.resolveEntity(cart);
        if (iLootrCart instanceof ILootrCart) {
            ILootrCart lootrCart = iLootrCart;
            lootrCart.setClientOpened(true);
            return;
        }
        LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as open as entity is not a Lootr-compatible entity.");
    }

    public static void handleOpenContainer(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(pos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity) {
            ILootrBlockEntity lootrBlockEntity = iLootrBlockEntity;
            lootrBlockEntity.setClientOpened(true);
            lootrBlockEntity.asBlockEntity().requestModelDataUpdate();
        }
        ClientHooks.clearCache(pos);
    }

    public static void handleCloseContainer(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(pos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity) {
            ILootrBlockEntity lootrBlockEntity = iLootrBlockEntity;
            lootrBlockEntity.setClientOpened(false);
            lootrBlockEntity.asBlockEntity().requestModelDataUpdate();
        }
        ClientHooks.clearCache(pos);
    }

    public static void handleRefresh() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ClientHooks.clearCache(player.blockPosition());
        }
    }
}

