/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;

public class Replacements {
    private static Set<Block> ignore = null;
    private static Map<Block, Block> replacements = null;

    public static void clearReplacements() {
        replacements = null;
        ignore = null;
    }

    public static BlockState replacement(BlockState original) {
        Block replacement;
        Block block;
        if (original.is(LootrTags.Blocks.CONVERT_BLACKLIST)) {
            return null;
        }
        if (original.is(LootrTags.Blocks.CONTAINERS)) {
            return null;
        }
        if (ignore == null) {
            ignore = new HashSet<Block>();
        }
        if (ignore.contains(original.getBlock())) {
            return null;
        }
        if (replacements == null) {
            replacements = new HashMap<Block, Block>();
        }
        if (replacements.get(original.getBlock()) == null && original.is(LootrTags.Blocks.CONVERT_BLOCK) && (block = original.getBlock()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity be = entityBlock.newBlockEntity(BlockPos.ZERO, original);
            if (LootrAPI.resolveBlockEntity(be) != null) {
                ignore.add(original.getBlock());
            }
            if (be instanceof RandomizableContainerBlockEntity) {
                if (original.is(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS)) {
                    replacements.put(original.getBlock(), LootrRegistry.getTrappedChestBlock());
                } else if (original.is(LootrTags.Blocks.CONVERT_BARRELS)) {
                    replacements.put(original.getBlock(), LootrRegistry.getBarrelBlock());
                } else if (original.is(LootrTags.Blocks.CONVERT_CHESTS)) {
                    replacements.put(original.getBlock(), LootrRegistry.getChestBlock());
                } else if (original.is(LootrTags.Blocks.CONVERT_SHULKERS)) {
                    replacements.put(original.getBlock(), LootrRegistry.getShulkerBlock());
                }
            }
        }
        if ((replacement = replacements.get(original.getBlock())) != null) {
            BlockState state = replacement.defaultBlockState();
            for (Property prop : original.getProperties()) {
                if (!state.hasProperty(prop)) continue;
                state = Replacements.safeReplace(state, original, prop);
            }
            return state;
        }
        ignore.add(original.getBlock());
        return null;
    }

    private static <V extends Comparable<V>> BlockState safeReplace(BlockState state, BlockState original, Property<V> property) {
        if (property == ChestBlock.TYPE && state.hasProperty(property)) {
            return (BlockState)state.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE);
        }
        if (original.hasProperty(property) && state.hasProperty(property)) {
            return (BlockState)state.setValue(property, original.getValue(property));
        }
        return state;
    }
}

