/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RemoveBookmarkMessage
implements Message {
    public static final CustomPacketPayload.Type<RemoveBookmarkMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"remove_bookmark"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveBookmarkMessage> STREAM_CODEC = StreamCodec.composite(BookAddress.STREAM_CODEC, m -> m.address, RemoveBookmarkMessage::new);
    public BookAddress address;

    public RemoveBookmarkMessage(BookAddress address) {
        this.address = address;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Book book = BookDataManager.get().getBook(this.address.bookId());
        BookVisualStateManager.get().removeBookmarkFor((Player)player, book, this.address);
        BookVisualStateManager.get().syncFor(player);
    }
}

