/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.bookmarks;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;

public class BookBookmarksScreen
extends BookPaginatedScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    protected final BookParentScreen parentScreen;
    private final List<BookAddress> visibleEntries = new ArrayList<BookAddress>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookAddress> allEntries;
    private BookTextHolder infoText;
    private List<Component> tooltip;

    public BookBookmarksScreen(BookParentScreen parentScreen) {
        super((Component)Component.translatable((String)"modonomicon.gui.bookmarks.screen.title"));
        this.parentScreen = parentScreen;
        this.infoText = new BookTextHolder("modonomicon.gui.bookmarks.info");
    }

    public void handleButtonEntry(Button button) {
        if (button instanceof EntryListButton) {
            EntryListButton entry = (EntryListButton)button;
            if (!BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, entry.getEntry())) {
                return;
            }
            this.onClose();
            if (entry.getAddressToOpen() != null) {
                BookGuiManager.get().openBook(entry.getAddressToOpen());
            } else {
                BookGuiManager.get().openEntry(entry.getEntry().getBook().getId(), entry.getEntry().getId(), 0);
            }
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.width((FormattedText)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookParentScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.renderComponentTooltip(this.font, this.tooltip, pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.renderables.remove(b);
            this.children().remove(b);
            this.narratables.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        this.visibleEntries.addAll(this.allEntries);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        this.resetTooltip();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -1300.0f);
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(guiGraphics, this.getTitle(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.bookmarks.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(guiGraphics, this.infoText, this.font, 12, 37, 124, 118);
        }
        if (this.visibleEntries.isEmpty()) {
            this.drawCenteredStringNoShadow(guiGraphics, (Component)Component.translatable((String)"modonomicon.gui.bookmarks.no_results"), 203, 80, 0x333333);
        }
        guiGraphics.pose().popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void onClose() {
        ClientServices.GUI.popGuiLayer();
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 257 && this.visibleEntries.size() == 1) {
            BookAddress entry = this.visibleEntries.get(0);
            this.onClose();
            BookGuiManager.get().openBook(entry);
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    public void init() {
        super.init();
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook(), (HolderLookup.Provider)this.minecraft.level.registryAccess());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = BookVisualStateManager.get().getBookmarksFor((Player)this.minecraft.player, this.getBook());
        this.createEntryList();
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            BookAddress address = this.visibleEntries.get(start + i);
            EntryListButton button = new EntryListButton(this.getBook().getEntry(address.entryId()), address, this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.addRenderableWidget((GuiEventListener)button);
            this.entryButtons.add(button);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

