/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.items.DynamicToolItem;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class Vajra
extends Item
implements DynamicToolItem,
ISimpleEnergyItem {
    private final long maxEnergy = CableTier.HV.getEu() * 10000L;
    private final long energyUsagePerBlock = this.maxEnergy / 6000L;
    public static final int MIN_SPEED = 1;
    public static final int MAX_SPEED = 4;

    public Vajra(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC).component(IOComponents.HIDE_BAR, (Object)false).component(IOComponents.VAJRA_SPEED, (Object)2).component(IOComponents.SILK_TOUCH, (Object)false).component(MIComponents.ENERGY, (Object)0L));
    }

    private static boolean isSilkTouch(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IOComponents.SILK_TOUCH, (Object)false);
    }

    private static void setSilkTouch(ItemStack stack, boolean silkTouch) {
        stack.set(IOComponents.SILK_TOUCH, (Object)silkTouch);
    }

    public static int getToolSpeed(ItemStack stack) {
        return (Integer)stack.getOrDefault(IOComponents.VAJRA_SPEED, (Object)2);
    }

    public static void setToolSpeed(ItemStack stack, int speed) {
        speed = Math.clamp((long)speed, 1, 4);
        stack.set(IOComponents.VAJRA_SPEED, (Object)speed);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is((Item)this) || slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is((Item)this) || !this.canUse(newStack);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (this.canUse(stack)) {
            this.useEnergy(stack, this.energyUsagePerBlock);
            return true;
        }
        return false;
    }

    private void useEnergy(ItemStack stack, long amount) {
        Long energy = (Long)stack.getOrDefault(MIComponents.ENERGY, (Object)0L);
        stack.set(MIComponents.ENERGY, (Object)Math.max(0L, energy - amount));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && player.isShiftKeyDown()) {
            ItemStack stack;
            Vajra.setSilkTouch(stack, !Vajra.isSilkTouch(stack = player.getItemInHand(hand)));
            if (level.isClientSide) {
                player.displayClientMessage((Component)IO.text().vajraSilkTouchInfo((Component)(Vajra.isSilkTouch(stack) ? IO.text().enabled() : IO.text().disabled())), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        ItemStack stack = ctx.getItemInHand();
        if (blockState.getDestroySpeed((BlockGetter)level, pos) < 0.0f) {
            return super.useOn(ctx);
        }
        Player player = ctx.getPlayer();
        if (player == null) {
            return super.useOn(ctx);
        }
        if (!this.canUse(stack)) {
            return super.useOn(ctx);
        }
        this.useEnergy(stack, this.energyUsagePerBlock);
        if (level.isClientSide && !level.isEmptyBlock(pos)) {
            player.swing(InteractionHand.MAIN_HAND);
        } else {
            block.playerWillDestroy(level, pos, blockState, player);
            if (level.removeBlock(pos, false)) {
                block.destroy((LevelAccessor)level, pos, blockState);
                block.playerDestroy(level, player, pos, blockState, blockEntity, stack);
                player.level().playSound(null, pos, block.getSoundType(blockState, (LevelReader)level, pos, (Entity)player).getBreakSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return Vajra.isSilkTouch(stack);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (Vajra.isSilkTouch(stack)) {
            lookup.get(Enchantments.SILK_TOUCH).ifPresent(h -> map.set((Holder)h, 1));
        }
        return map.toImmutable();
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.canUse(stack);
    }

    private boolean canUse(ItemStack stack) {
        Long energy = (Long)stack.getOrDefault(MIComponents.ENERGY, (Object)0L);
        return energy >= this.energyUsagePerBlock;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!this.canUse(stack)) {
            return 0.0f;
        }
        float baseSpeed = state.getDestroySpeed(null, null);
        if (baseSpeed < 0.0f) {
            return super.getDestroySpeed(stack, state);
        }
        switch (Vajra.getToolSpeed(stack)) {
            case 1: {
                return baseSpeed * 4.0f;
            }
            case 2: {
                return baseSpeed * 7.5f;
            }
            case 3: {
                return baseSpeed * 29.0f;
            }
            case 4: {
                baseSpeed = Float.MAX_VALUE;
                return Float.MAX_VALUE;
            }
        }
        return baseSpeed;
    }

    public DataComponentType<Long> getEnergyComponent() {
        return (DataComponentType)MIComponents.ENERGY.get();
    }

    public long getEnergyCapacity(ItemStack stack) {
        return this.maxEnergy;
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return this.maxEnergy;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return this.maxEnergy;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return (Boolean)stack.getOrDefault(IOComponents.HIDE_BAR, (Object)false) == false;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.getEnergyCapacity(stack) * 13.0);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return 0xFF0000;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        MutableComponent speed = null;
        switch (Vajra.getToolSpeed(stack)) {
            case 1: {
                speed = IO.text().vajraSpeedSlow();
                break;
            }
            case 2: {
                speed = IO.text().vajraSpeedNormal();
                break;
            }
            case 3: {
                speed = IO.text().vajraSpeedFast();
                break;
            }
            case 4: {
                speed = IO.text().vajraSpeedInstant();
            }
        }
        tooltip.add((Component)IO.text().vajraSpeedInfo((Component)speed));
        tooltip.add((Component)IO.text().vajraSilkTouchInfo((Component)(Vajra.isSilkTouch(stack) ? IO.text().enabled() : IO.text().disabled())));
        tooltip.add((Component)IO.text().energyInfo((Long)stack.getOrDefault(MIComponents.ENERGY, (Object)0L), this.getEnergyCapacity(stack)));
    }
}

