/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.item;

import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import dev.wp.industrialization_overdrive.IOComponents;
import dev.wp.industrialization_overdrive.IOUtil;
import dev.wp.industrialization_overdrive.compat.AE2Integration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class Terminal
extends Item {
    private static final int COLOR_MISSING = DyeColor.RED.getTextColor();
    private static final int COLOR_ENOUGH = DyeColor.GREEN.getTextColor();
    private static final int COLOR_HEADER = DyeColor.YELLOW.getTextColor();

    public Terminal(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.RARE));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (!IOUtil.isRealPlayer(player) || level.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MultiblockMachineBlockEntity)) {
            return InteractionResult.PASS;
        }
        MultiblockMachineBlockEntity multiblock = (MultiblockMachineBlockEntity)blockEntity;
        return this.handleMultiblockUse(level, pos, player, multiblock);
    }

    private InteractionResult handleMultiblockUse(Level level, BlockPos pos, Player player, MultiblockMachineBlockEntity multiblock) {
        ShapeMatcher shapeMatcher = multiblock.createShapeMatcher();
        if (shapeMatcher == null) {
            player.sendSystemMessage((Component)Component.literal((String)"Unable to get shape matcher for this multiblock.").withColor(COLOR_MISSING));
            return InteractionResult.FAIL;
        }
        if (player.isCreative()) {
            this.buildMultiblock(level, pos, player, shapeMatcher);
            return InteractionResult.SUCCESS;
        }
        return this.handleSurvivalBuild(level, pos, player, shapeMatcher);
    }

    private void buildMultiblock(Level level, BlockPos pos, Player player, ShapeMatcher shapeMatcher) {
        for (BlockPos memberPos : shapeMatcher.getPositions()) {
            SimpleMember member;
            BlockState previewState;
            if (Terminal.isAlreadyValid(shapeMatcher, level, memberPos) || (previewState = (member = shapeMatcher.getSimpleMember(memberPos)) != null ? member.getPreviewState() : null) == null) continue;
            level.setBlock(memberPos, previewState, 3);
        }
        player.sendSystemMessage((Component)Component.literal((String)String.format("Successfully built multiblock at %s, %s, %s", pos.getX(), pos.getY(), pos.getZ())).withColor(COLOR_ENOUGH));
    }

    private InteractionResult handleSurvivalBuild(Level level, BlockPos pos, Player player, ShapeMatcher shapeMatcher) {
        HashMap<Item, Integer> requiredBlocks = new HashMap<Item, Integer>();
        boolean obstructionFound = false;
        for (BlockPos checkPos : shapeMatcher.getPositions()) {
            BlockState previewState;
            if (Terminal.isAlreadyValid(shapeMatcher, level, checkPos)) continue;
            BlockState state = level.getBlockState(checkPos);
            SimpleMember member = shapeMatcher.getSimpleMember(checkPos);
            BlockState blockState = previewState = member != null ? member.getPreviewState() : null;
            if (!state.canBeReplaced()) {
                obstructionFound = true;
                player.sendSystemMessage((Component)Component.literal((String)String.format("Block at %s is not part of the multiblock", checkPos.toShortString())).withColor(COLOR_MISSING));
            }
            if (!state.canBeReplaced() || previewState == null) continue;
            Item block = previewState.getBlock().asItem();
            requiredBlocks.merge(block, 1, Integer::sum);
        }
        if (obstructionFound) {
            return InteractionResult.SUCCESS;
        }
        if (!this.checkAndConsumeInventory(player, level, requiredBlocks)) {
            return InteractionResult.FAIL;
        }
        this.buildMultiblock(level, pos, player, shapeMatcher);
        return InteractionResult.SUCCESS;
    }

    private boolean checkAndConsumeInventory(Player player, Level level, Map<Item, Integer> requiredBlocks) {
        int missing;
        int inMe;
        int inInv;
        int required;
        Map<Item, Integer> inventoryCount = Terminal.countInventory(player);
        HashMap<Item, Integer> missingItems = new HashMap<Item, Integer>();
        for (Map.Entry<Item, Integer> entry : requiredBlocks.entrySet()) {
            Item block = entry.getKey();
            int requiredCount = entry.getValue();
            int countInInventory = inventoryCount.getOrDefault(block, 0);
            if (countInInventory >= requiredCount) continue;
            missingItems.put(block, requiredCount - countInInventory);
        }
        Map<Object, Object> meProvided = IOUtil.isAE2Loaded ? AE2Integration.simulateExtractFromME(player, level, missingItems) : new HashMap();
        boolean anyMissing = false;
        for (Map.Entry<Item, Integer> entry : requiredBlocks.entrySet()) {
            Item item = entry.getKey();
            required = entry.getValue();
            missing = required - ((inInv = inventoryCount.getOrDefault(item, 0).intValue()) + (inMe = ((Integer)meProvided.getOrDefault(item, 0)).intValue()));
            if (missing <= 0) continue;
            anyMissing = true;
            break;
        }
        if (anyMissing) {
            player.sendSystemMessage((Component)Component.literal((String)"Required items:").withColor(COLOR_HEADER));
            for (Map.Entry<Item, Integer> entry : requiredBlocks.entrySet()) {
                Item item = entry.getKey();
                required = entry.getValue();
                missing = required - ((inInv = inventoryCount.getOrDefault(item, 0).intValue()) + (inMe = ((Integer)meProvided.getOrDefault(item, 0)).intValue()));
                if (missing > 0) {
                    player.sendSystemMessage(Terminal.formatItemLine(item, missing, COLOR_MISSING));
                    continue;
                }
                player.sendSystemMessage(Terminal.formatItemLine(item, required, COLOR_ENOUGH));
            }
            return false;
        }
        if (IOUtil.isAE2Loaded && !meProvided.isEmpty()) {
            AE2Integration.extractFromME(player, level, meProvided);
        }
        Terminal.consumeFromInventory(player, requiredBlocks);
        return true;
    }

    private static Map<Item, Integer> countInventory(Player player) {
        HashMap<Item, Integer> inventoryCount = new HashMap<Item, Integer>();
        for (ItemStack stack : player.getInventory().items) {
            Item id = stack.getItem();
            inventoryCount.merge(id, stack.getCount(), Integer::sum);
        }
        return inventoryCount;
    }

    private static void consumeFromInventory(Player player, Map<Item, Integer> requiredBlocks) {
        block0: for (Map.Entry<Item, Integer> entry : requiredBlocks.entrySet()) {
            Item block = entry.getKey();
            int remainingToConsume = entry.getValue();
            for (ItemStack stack : player.getInventory().items) {
                if (!stack.getItem().equals(block) || remainingToConsume <= 0) continue;
                int amountToShrink = Math.min(remainingToConsume, stack.getCount());
                stack.shrink(amountToShrink);
                if ((remainingToConsume -= amountToShrink) != 0) continue;
                continue block0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAlreadyValid(ShapeMatcher shapeMatcher, Level level, BlockPos pos) {
        if (shapeMatcher.matches(pos, level)) {
            return true;
        }
        BlockEntity be = level.getBlockEntity(pos);
        HatchFlags hatchFlags = shapeMatcher.getHatchFlags(pos);
        if (!(be instanceof HatchBlockEntity)) return false;
        HatchBlockEntity hatch = (HatchBlockEntity)be;
        if (hatchFlags == null) return false;
        if (!hatchFlags.allows(hatch.getHatchType())) return false;
        return true;
    }

    private static Component formatItemLine(Item item, int count, int color) {
        String name = item.getDefaultInstance().getHoverName().getString();
        return Component.literal((String)String.format("- %sx %s", count, name)).withColor(color);
    }

    public static GlobalPos getLinkPos(ItemStack stack) {
        return (GlobalPos)stack.get(IOComponents.TERMINAL_LINK);
    }

    public static void setLinkPos(ItemStack stack, GlobalPos pos) {
        stack.set(IOComponents.TERMINAL_LINK, (Object)pos);
    }

    public static void clearLinkPos(ItemStack stack) {
        stack.remove(IOComponents.TERMINAL_LINK);
    }
}

