/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive;

import com.google.common.collect.Lists;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOItems;
import dev.wp.industrialization_overdrive.IOUtil;
import dev.wp.industrialization_overdrive.item.Terminal;
import dev.wp.industrialization_overdrive.machines.blockentities.multiblock.PyrolyseOvenBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;

public class IOTooltips {
    private static final BiParser<Boolean, Float> MAYBE_SPACED_PERCENTAGE_PARSER = (space, ratio) -> Component.literal((String)"%d%s%%".formatted((int)(ratio.floatValue() * 100.0f), space != false ? " " : ""));
    public static final Parser<Float> PERCENTAGE_PARSER = ratio -> MAYBE_SPACED_PERCENTAGE_PARSER.parse((Object)false, ratio);
    public static final Parser<BlockPos> POS_PARSER = pos -> Component.literal((String)"%d, %d, %d".formatted(pos.getX(), pos.getY(), pos.getZ()));
    public static final TooltipAttachment COILS_PYRO = TooltipAttachment.singleLine((stack, item) -> {
        if (!(item instanceof BlockItem)) return false;
        BlockItem blockItem = (BlockItem)item;
        if (!PyrolyseOvenBlockEntity.getTiersByCoil().containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()))) return false;
        return true;
    }, (flags, ctx, stack, item) -> {
        PyrolyseOvenBlockEntity.Tier tier = PyrolyseOvenBlockEntity.getTiersByCoil().get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)stack.getItem()).getBlock()));
        int batchSize = tier.batchSize();
        float euCostMultiplier = tier.euCostMultiplier();
        return IO.text().coilsPyroTier(batchSize, euCostMultiplier);
    });
    public static final TooltipAttachment TERMINAL = TooltipAttachment.multilines(IOItems.TERMINAL, (flags, ctx, stack, item) -> {
        ArrayList tooltip = Lists.newArrayList();
        if (IOUtil.isAE2Loaded) {
            GlobalPos linkPos = Terminal.getLinkPos(stack);
            if (linkPos != null) {
                tooltip.add(IO.text().terminalLinkInfo(linkPos.pos()));
            } else {
                tooltip.add(IO.text().terminalLinkNotLinked());
            }
        }
        tooltip.add(IO.text().terminalHelp1("sneak", "use"));
        tooltip.add(IOUtil.isAE2Loaded ? IO.text().terminalHelp2Alt() : IO.text().terminalHelp2());
        return tooltip;
    });

    public static void init() {
    }
}

