/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.importer;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterSource;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.FluidHandlerExtractableStorage;
import com.refinedmods.refinedstorage.neoforge.storage.FluidHandlerInsertableStorage;
import java.util.Iterator;

class FluidHandlerImporterSource
implements ImporterSource {
    private final CapabilityCache capabilityCache;
    private final FluidHandlerInsertableStorage insertTarget;
    private final FluidHandlerExtractableStorage extractTarget;

    FluidHandlerImporterSource(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
        this.insertTarget = new FluidHandlerInsertableStorage(capabilityCache);
        this.extractTarget = new FluidHandlerExtractableStorage(capabilityCache);
    }

    public long getAmount(ResourceKey resource) {
        return this.extractTarget.getAmount(resource);
    }

    @Override
    public Iterator<ResourceKey> getResources() {
        return this.capabilityCache.getFluidIterator();
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.extractTarget.extract(resource, amount, action, actor);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.insertTarget.insert(resource, amount, action, actor);
    }
}

