/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class FluidGridExtractionStrategy
implements GridExtractionStrategy {
    private static final ItemResource BUCKET_ITEM_RESOURCE = new ItemResource(Items.BUCKET);
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;
    private final PlayerMainInvWrapper playerInventoryStorage;
    private final Storage itemStorage;

    public FluidGridExtractionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.menu = containerMenu;
        this.gridOperations = grid.createOperations(ResourceTypes.FLUID, player);
        this.playerInventoryStorage = new PlayerMainInvWrapper(player.getInventory());
        this.itemStorage = grid.getItemStorage();
    }

    @Override
    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            boolean containerOnCursor = this.isFluidContainerOnCursor();
            boolean bucketInInventory = this.hasBucketInInventory();
            boolean bucketInStorage = this.hasBucketInStorage();
            if (containerOnCursor) {
                this.extractWithContainerOnCursor(fluidResource, extractMode);
            } else if (bucketInInventory) {
                this.extract(fluidResource, extractMode, cursor, true);
            } else if (bucketInStorage) {
                this.extract(fluidResource, extractMode, cursor, false);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private IFluidHandlerItem getFluidStorage(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
    }

    private void extractWithContainerOnCursor(FluidResource fluidResource, GridExtractMode mode) {
        this.gridOperations.extract(fluidResource, mode, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            IFluidHandlerItem destination = this.getFluidStorage(this.menu.getCarried());
            if (destination == null) {
                return 0L;
            }
            int inserted = destination.fill(VariantUtil.toFluidStack(fluidResource2, amount), VariantUtil.toFluidAction(action));
            if (inserted > 0 && action == Action.EXECUTE) {
                this.menu.setCarried(destination.getContainer());
            }
            return inserted;
        });
    }

    private void extract(FluidResource fluidResource, GridExtractMode mode, boolean cursor, boolean bucketFromInventory) {
        IFluidHandlerItem destination = this.getFluidStorage(BUCKET_ITEM_RESOURCE.toItemStack());
        if (destination == null) {
            return;
        }
        this.gridOperations.extract(fluidResource, mode, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            int inserted = destination.fill(VariantUtil.toFluidStack(fluidResource2, amount), VariantUtil.toFluidAction(action));
            if (action == Action.EXECUTE) {
                this.extractSourceBucket(bucketFromInventory, source);
                if (!this.insertResultingBucket(cursor, destination)) {
                    this.insertSourceBucket(bucketFromInventory, source);
                    return 0L;
                }
            }
            return inserted;
        });
    }

    private void extractSourceBucket(boolean bucketFromInventory, Actor actor) {
        if (bucketFromInventory) {
            this.extractBucket((IItemHandler)this.playerInventoryStorage, Action.EXECUTE);
        } else {
            this.itemStorage.extract(BUCKET_ITEM_RESOURCE, 1L, Action.EXECUTE, actor);
        }
    }

    private void insertSourceBucket(boolean bucketFromInventory, Actor actor) {
        if (bucketFromInventory) {
            this.insertBucket((IItemHandler)this.playerInventoryStorage);
        } else {
            this.itemStorage.insert(BUCKET_ITEM_RESOURCE, 1L, Action.EXECUTE, actor);
        }
    }

    private boolean insertResultingBucket(boolean cursor, IFluidHandlerItem destination) {
        if (cursor) {
            this.menu.setCarried(destination.getContainer());
            return true;
        }
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.playerInventoryStorage, (ItemStack)destination.getContainer(), (boolean)false);
        return remainder.isEmpty();
    }

    private boolean isFluidContainerOnCursor() {
        return this.getFluidStorage(this.menu.getCarried()) != null;
    }

    private boolean hasBucketInStorage() {
        return this.itemStorage.extract(BUCKET_ITEM_RESOURCE, 1L, Action.SIMULATE, Actor.EMPTY) == 1L;
    }

    private boolean hasBucketInInventory() {
        return this.extractBucket((IItemHandler)this.playerInventoryStorage, Action.SIMULATE);
    }

    private boolean extractBucket(IItemHandler source, Action action) {
        ItemStack toExtractStack = BUCKET_ITEM_RESOURCE.toItemStack();
        for (int slot = 0; slot < source.getSlots(); ++slot) {
            boolean relevant = this.isSame(source.getStackInSlot(slot), toExtractStack);
            if (!relevant || source.extractItem(slot, 1, action == Action.SIMULATE).getCount() != 1) continue;
            return true;
        }
        return false;
    }

    private void insertBucket(IItemHandler destination) {
        ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)BUCKET_ITEM_RESOURCE.toItemStack(), (boolean)false);
    }

    private boolean isSame(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }
}

