/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge;

import com.refinedmods.refinedstorage.common.AbstractClientModInitializer;
import com.refinedmods.refinedstorage.common.AbstractModInitializer;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.PlatformProxy;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.WirelessAutocraftingMonitorItem;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntityProviders;
import com.refinedmods.refinedstorage.common.content.BlockEntityTypeFactory;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.CreativeModeTabItems;
import com.refinedmods.refinedstorage.common.content.DirectRegistryCallback;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.content.MenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockItem;
import com.refinedmods.refinedstorage.common.grid.WirelessGridItem;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.SecurityCardItem;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItem;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocrafterNameChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingMonitorCancelAllPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingMonitorCancelPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewCancelRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewMaxAmountRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.CraftingGridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.CraftingGridRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.FilterSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridExtractPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridInsertPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridScrollPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridAllowedAlternativesChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridCraftingRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridCreatePatternPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridProcessingRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridSmithingTableRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridStonecutterRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PropertyChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceFilterSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceSlotAmountChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardBoundPlayerPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardPermissionPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardResetPermissionPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SingleAmountChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.StorageInfoRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.UseSlotReferencedItemPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterLockedUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterManagerActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterNameUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskAddedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskRemovedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskStatusChangedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewCancelResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewMaxAmountResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingTaskCompletedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingTreePreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.EnergyInfoPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ExportingIndicatorUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.MessagePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.NetworkTransmitterStatusPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.PatternGridAllowedAlternativesUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ResourceSlotUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.StorageInfoResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.WirelessTransmitterDataPacket;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.ServerListener;
import com.refinedmods.refinedstorage.neoforge.ClientModInitializer;
import com.refinedmods.refinedstorage.neoforge.PlatformImpl;
import com.refinedmods.refinedstorage.neoforge.RefinedStorageNeoForgeApiImpl;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApiProxy;
import com.refinedmods.refinedstorage.neoforge.autocrafting.FluidHandlerExternalPatternProviderSinkFactory;
import com.refinedmods.refinedstorage.neoforge.autocrafting.ItemHandlerExternalPatternProviderSinkFactory;
import com.refinedmods.refinedstorage.neoforge.constructordestructor.ForgeConstructorBlockEntity;
import com.refinedmods.refinedstorage.neoforge.constructordestructor.ForgeDestructorBlockEntity;
import com.refinedmods.refinedstorage.neoforge.debug.DebugStickItem;
import com.refinedmods.refinedstorage.neoforge.exporter.FluidHandlerExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.neoforge.exporter.ForgeExporterBlockEntity;
import com.refinedmods.refinedstorage.neoforge.exporter.ItemHandlerExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.FluidGridExtractionStrategy;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.FluidGridInsertionStrategy;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.ItemGridExtractionStrategy;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.ItemGridScrollingStrategy;
import com.refinedmods.refinedstorage.neoforge.grid.view.ForgeFluidResourceRepositoryMapper;
import com.refinedmods.refinedstorage.neoforge.grid.view.ForgeItemResourceRepositoryMapper;
import com.refinedmods.refinedstorage.neoforge.importer.FluidHandlerImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.neoforge.importer.ForgeImporterBlockEntity;
import com.refinedmods.refinedstorage.neoforge.importer.ItemHandlerImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.neoforge.networking.ForgeCableBlockEntity;
import com.refinedmods.refinedstorage.neoforge.storage.diskdrive.ForgeDiskDriveBlockEntity;
import com.refinedmods.refinedstorage.neoforge.storage.diskinterface.ForgeDiskInterfaceBlockEntity;
import com.refinedmods.refinedstorage.neoforge.storage.externalstorage.FluidHandlerExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.neoforge.storage.externalstorage.ForgeExternalStorageBlockEntity;
import com.refinedmods.refinedstorage.neoforge.storage.externalstorage.ItemHandlerPlatformExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.neoforge.storage.portablegrid.ForgePortableGridBlockEntity;
import com.refinedmods.refinedstorage.neoforge.support.energy.EnergyStorageAdapter;
import com.refinedmods.refinedstorage.neoforge.support.inventory.InsertExtractItemHandler;
import com.refinedmods.refinedstorage.neoforge.support.resource.ResourceContainerFluidHandlerAdapter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="refinedstorage")
public class ModInitializer
extends AbstractModInitializer {
    private static final BlockEntityProviders BLOCK_ENTITY_PROVIDERS = new BlockEntityProviders(ForgeDiskDriveBlockEntity::new, (pos, state) -> new ForgePortableGridBlockEntity(PortableGridType.NORMAL, pos, state), (pos, state) -> new ForgePortableGridBlockEntity(PortableGridType.CREATIVE, pos, state), ForgeDiskInterfaceBlockEntity::new, ForgeCableBlockEntity::new, ForgeExternalStorageBlockEntity::new, ForgeExporterBlockEntity::new, ForgeImporterBlockEntity::new, ForgeConstructorBlockEntity::new, ForgeDestructorBlockEntity::new);
    private final DeferredRegister<Block> blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"refinedstorage");
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"refinedstorage");
    private final DeferredRegister<BlockEntityType<?>> blockEntityTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"refinedstorage");
    private final DeferredRegister<MenuType<?>> menuTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"refinedstorage");
    private final DeferredRegister<SoundEvent> soundEventRegistry = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"refinedstorage");
    private final DeferredRegister<RecipeSerializer<?>> recipeSerializerRegistry = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"refinedstorage");
    private final DeferredRegister<DataComponentType<?>> dataComponentTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"refinedstorage");
    private final String modVersion;

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        this.modVersion = modContainer.getModInfo().getVersion().toString();
        PlatformProxy.loadPlatform(new PlatformImpl(modContainer));
        this.initializePlatformApi();
        ((RefinedStorageNeoForgeApiProxy)RefinedStorageNeoForgeApi.INSTANCE).setDelegate(new RefinedStorageNeoForgeApiImpl());
        this.registerGridResourceRepositoryMappers();
        this.registerAdditionalGridInsertionStrategyFactories();
        this.registerGridExtractionStrategyFactories();
        this.registerGridScrollingStrategyFactories();
        this.registerImporterTransferStrategyFactories();
        this.registerExporterTransferStrategyFactories();
        this.registerExternalStorageProviderFactories();
        this.registerPatternProviderSinkFactories();
        this.registerContent(eventBus);
        this.registerSounds(eventBus);
        this.registerRecipeSerializers(eventBus);
        this.registerTickHandler();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AbstractClientModInitializer.initializeClientPlatformApi();
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterCustomModels);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            eventBus.addListener(ClientModInitializer::onRegisterKeyMappings);
            eventBus.addListener(ClientModInitializer::onRegisterTooltipFactories);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::onCommonSetup);
        eventBus.addListener(this::onRegister);
        eventBus.addListener(this::registerPackets);
        eventBus.addListener(this::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(this::registerWrenchingEvent);
        NeoForge.EVENT_BUS.addListener(this::registerSecurityBlockBreakEvent);
    }

    private void registerGridResourceRepositoryMappers() {
        RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(ItemResource.class, new ForgeItemResourceRepositoryMapper());
        RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(FluidResource.class, new ForgeFluidResourceRepositoryMapper());
    }

    private void registerAdditionalGridInsertionStrategyFactories() {
        RefinedStorageApi.INSTANCE.addGridInsertionStrategyFactory(FluidGridInsertionStrategy::new);
    }

    private void registerGridExtractionStrategyFactories() {
        RefinedStorageApi.INSTANCE.addGridExtractionStrategyFactory(ItemGridExtractionStrategy::new);
        RefinedStorageApi.INSTANCE.addGridExtractionStrategyFactory(FluidGridExtractionStrategy::new);
    }

    private void registerGridScrollingStrategyFactories() {
        RefinedStorageApi.INSTANCE.addGridScrollingStrategyFactory(ItemGridScrollingStrategy::new);
    }

    private void registerImporterTransferStrategyFactories() {
        RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(IdentifierUtil.createIdentifier("item"), new ItemHandlerImporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(IdentifierUtil.createIdentifier("fluid"), new FluidHandlerImporterTransferStrategyFactory());
    }

    private void registerExporterTransferStrategyFactories() {
        RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(IdentifierUtil.createIdentifier("item"), new ItemHandlerExporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(IdentifierUtil.createIdentifier("fluid"), new FluidHandlerExporterTransferStrategyFactory());
    }

    private void registerExternalStorageProviderFactories() {
        RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory(new ItemHandlerPlatformExternalStorageProviderFactory());
        RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory(new FluidHandlerExternalStorageProviderFactory());
    }

    private void registerPatternProviderSinkFactories() {
        RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory(new ItemHandlerExternalPatternProviderSinkFactory());
        RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory(new FluidHandlerExternalPatternProviderSinkFactory());
    }

    private void registerContent(IEventBus eventBus) {
        this.registerBlocks(eventBus);
        this.registerItems(eventBus);
        this.registerBlockEntities(eventBus);
        this.registerMenus(eventBus);
        this.registerDataComponents(eventBus);
    }

    private void registerBlocks(IEventBus eventBus) {
        this.registerBlocks(new ForgeRegistryCallback<Block>(this.blockRegistry), BLOCK_ENTITY_PROVIDERS);
        this.blockRegistry.register(eventBus);
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        this.registerItems(callback);
        Items.INSTANCE.setDebugStick(callback.register(ContentIds.DEBUG_STICK, DebugStickItem::new));
        this.registerCustomItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerCustomItems(RegistryCallback<Item> callback) {
        Items.INSTANCE.setRegulatorUpgrade(callback.register(ContentIds.REGULATOR_UPGRADE, () -> new RegulatorUpgradeItem(this, RefinedStorageApi.INSTANCE.getUpgradeRegistry()){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setWirelessGrid(callback.register(ContentIds.WIRELESS_GRID, () -> new WirelessGridItem(this, false){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setCreativeWirelessGrid(callback.register(ContentIds.CREATIVE_WIRELESS_GRID, () -> new WirelessGridItem(this, true){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setPortableGrid(callback.register(ContentIds.PORTABLE_GRID, () -> new PortableGridBlockItem(this, Blocks.INSTANCE.getPortableGrid(), PortableGridType.NORMAL){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setCreativePortableGrid(callback.register(ContentIds.CREATIVE_PORTABLE_GRID, () -> new PortableGridBlockItem(this, Blocks.INSTANCE.getCreativePortableGrid(), PortableGridType.CREATIVE){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setSecurityCard(callback.register(ContentIds.SECURITY_CARD, () -> new SecurityCardItem(this){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setFallbackSecurityCard(callback.register(ContentIds.FALLBACK_SECURITY_CARD, () -> new FallbackSecurityCardItem(this){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setWirelessAutocraftingMonitor(callback.register(ContentIds.WIRELESS_AUTOCRAFTING_MONITOR, () -> new WirelessAutocraftingMonitorItem(this, false){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
        Items.INSTANCE.setCreativeWirelessAutocraftingMonitor(callback.register(ContentIds.CREATIVE_WIRELESS_AUTOCRAFTING_MONITOR, () -> new WirelessAutocraftingMonitorItem(this, true){

            public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
                return ModInitializer.allowComponentsUpdateAnimation(oldStack, newStack);
            }
        }));
    }

    private void registerBlockEntities(IEventBus eventBus) {
        this.registerBlockEntities(new ForgeRegistryCallback(this.blockEntityTypeRegistry), new BlockEntityTypeFactory(this){

            @Override
            public <T extends BlockEntity> BlockEntityType<T> create(BlockEntityProvider<T> factory, Block ... allowedBlocks) {
                return new BlockEntityType(factory::create, new HashSet<Block>(Arrays.asList(allowedBlocks)), null);
            }
        }, BLOCK_ENTITY_PROVIDERS);
        this.blockEntityTypeRegistry.register(eventBus);
    }

    private void registerMenus(IEventBus eventBus) {
        this.registerMenus(new ForgeRegistryCallback(this.menuTypeRegistry), new MenuTypeFactory(this){

            @Override
            public <T extends AbstractContainerMenu> MenuType<T> create(MenuTypeFactory.MenuSupplier<T> supplier) {
                return new MenuType(supplier::create, FeatureFlags.DEFAULT_FLAGS);
            }
        }, new ExtendedMenuTypeFactory(this){

            @Override
            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        });
        this.menuTypeRegistry.register(eventBus);
    }

    private void registerDataComponents(IEventBus eventBus) {
        ForgeRegistryCallback callback = new ForgeRegistryCallback(this.dataComponentTypeRegistry);
        this.registerDataComponents(callback);
        this.dataComponentTypeRegistry.register(eventBus);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getCable());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getConstructor());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getController());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getCraftingGrid());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getPatternGrid());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getCreativeController());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getDestructor());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getDetector());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getDiskDrive());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getDiskInterface());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getExporter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getExternalStorage());
        Arrays.stream(FluidStorageVariant.values()).forEach(type -> this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getFluidStorageBlock((FluidStorageVariant)type)));
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getGrid());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getImporter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getInterface());
        Arrays.stream(ItemStorageVariant.values()).forEach(type -> this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getItemStorageBlock((ItemStorageVariant)type)));
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getNetworkReceiver());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getNetworkTransmitter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getRelay());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getSecurityManager());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getStorageMonitor());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getWirelessTransmitter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getAutocrafter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getAutocrafterManager());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getAutocraftingMonitor());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getDiskDrive(), (be, side) -> new InvWrapper((Container)be.getDiskInventory()));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getInterface(), (be, side) -> new InvWrapper(be.getExportedResourcesAsContainer()));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getPatternGrid(), (be, side) -> new InvWrapper((Container)be.getPatternInput()));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntities.INSTANCE.getInterface(), (be, side) -> new ResourceContainerFluidHandlerAdapter(be.getExportedResources()));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, BlockEntities.INSTANCE.getController(), (be, side) -> new EnergyStorageAdapter(be.getEnergyStorage()));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, BlockEntities.INSTANCE.getPortableGrid(), (be, side) -> new EnergyStorageAdapter(be.getEnergyStorage()));
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(Items.INSTANCE.getWirelessGrid().createEnergyStorage((ItemStack)stack)), new ItemLike[]{Items.INSTANCE.getWirelessGrid()});
        Items.INSTANCE.getControllers().forEach(controllerItem -> event.registerItem(Capabilities.EnergyStorage.ITEM, (arg_0, arg_1) -> ModInitializer.lambda$registerCapabilities$20((Supplier)controllerItem, arg_0, arg_1), new ItemLike[]{(ItemLike)controllerItem.get()}));
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(PortableGridBlockItem.createEnergyStorage(stack)), new ItemLike[]{Items.INSTANCE.getPortableGrid()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new EnergyStorageAdapter(Items.INSTANCE.getWirelessAutocraftingMonitor().createEnergyStorage((ItemStack)stack)), new ItemLike[]{Items.INSTANCE.getWirelessAutocraftingMonitor()});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.INSTANCE.getDiskInterface(), (be, side) -> {
            InvWrapper wrapper = new InvWrapper((Container)be.getDiskInventory());
            return new InsertExtractItemHandler((IItemHandler)new RangedWrapper((IItemHandlerModifiable)wrapper, 0, 3), (IItemHandler)new RangedWrapper((IItemHandlerModifiable)wrapper, 3, 6));
        });
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    private void registerSounds(IEventBus eventBus) {
        this.registerSounds(new ForgeRegistryCallback<SoundEvent>(this.soundEventRegistry));
        this.soundEventRegistry.register(eventBus);
    }

    private void registerRecipeSerializers(IEventBus eventBus) {
        this.registerRecipeSerializers(new ForgeRegistryCallback(this.recipeSerializerRegistry));
        this.recipeSerializerRegistry.register(eventBus);
    }

    private void registerTickHandler() {
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onServerStopped);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent e) {
        this.registerUpgradeMappings();
    }

    @SubscribeEvent
    public void onRegister(RegisterEvent e) {
        e.register(Registries.LOOT_FUNCTION_TYPE, helper -> this.registerLootFunctions(new DirectRegistryCallback(BuiltInRegistries.LOOT_FUNCTION_TYPE)));
        e.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(RefinedStorageApi.INSTANCE.getCreativeModeTabId(), (Object)CreativeModeTab.builder().title((Component)ContentNames.MOD).icon(() -> new ItemStack((ItemLike)Blocks.INSTANCE.getCreativeController().getDefault())).displayItems((params, output) -> {
            CreativeModeTabItems.append(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            if (Platform.INSTANCE.getConfig().isDebug()) {
                output.accept((ItemLike)Items.INSTANCE.getDebugStick());
            }
        }).build()));
        e.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(RefinedStorageApi.INSTANCE.getColoredCreativeModeTabId(), (Object)CreativeModeTab.builder().title((Component)ContentNames.MOD_COLORIZED).icon(() -> new ItemStack((ItemLike)Blocks.INSTANCE.getCreativeController().get(DyeColor.LIME))).displayItems((params, output) -> CreativeModeTabItems.appendColoredVariants(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build()));
    }

    @SubscribeEvent
    public void registerWrenchingEvent(PlayerInteractEvent.RightClickBlock e) {
        Level level = e.getLevel();
        BlockState state = level.getBlockState(e.getHitVec().getBlockPos());
        Block block = state.getBlock();
        if (!(block instanceof AbstractBaseBlock)) {
            return;
        }
        AbstractBaseBlock block2 = (AbstractBaseBlock)block;
        block2.tryUseWrench(state, level, e.getHitVec(), e.getEntity(), e.getHand()).or(() -> block2.tryUpdateColor(state, level, e.getHitVec().getBlockPos(), e.getEntity(), e.getHand())).ifPresent(result -> {
            e.setCanceled(true);
            e.setCancellationResult(result);
        });
    }

    @SubscribeEvent
    public void registerSecurityBlockBreakEvent(BlockEvent.BreakEvent e) {
        ServerPlayer serverPlayer;
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        NetworkNodeContainerProvider provider = Platform.INSTANCE.getContainerProvider(level, e.getPos(), null);
        Player player = e.getPlayer();
        if (provider != null && player instanceof ServerPlayer && !provider.canBuild(serverPlayer = (ServerPlayer)player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(serverPlayer, (Component)IdentifierUtil.createTranslation("misc", "no_permission.build.break", e.getState().getBlock().getName()));
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.modVersion);
        ModInitializer.registerServerToClientPackets(registrar);
        ModInitializer.registerClientToServerPackets(registrar);
    }

    private static void registerServerToClientPackets(PayloadRegistrar registrar) {
        registrar.playToClient(EnergyInfoPacket.PACKET_TYPE, EnergyInfoPacket.STREAM_CODEC, ModInitializer.wrapHandler(EnergyInfoPacket::handle));
        registrar.playToClient(GridActivePacket.PACKET_TYPE, GridActivePacket.STREAM_CODEC, ModInitializer.wrapHandler(GridActivePacket::handle));
        registrar.playToClient(AutocrafterManagerActivePacket.PACKET_TYPE, AutocrafterManagerActivePacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocrafterManagerActivePacket::handle));
        registrar.playToClient(GridClearPacket.PACKET_TYPE, GridClearPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> GridClearPacket.handle(ctx)));
        registrar.playToClient(GridUpdatePacket.PACKET_TYPE, GridUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(GridUpdatePacket::handle));
        registrar.playToClient(NetworkTransmitterStatusPacket.PACKET_TYPE, NetworkTransmitterStatusPacket.STREAM_CODEC, ModInitializer.wrapHandler(NetworkTransmitterStatusPacket::handle));
        registrar.playToClient(ResourceSlotUpdatePacket.PACKET_TYPE, ResourceSlotUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(ResourceSlotUpdatePacket::handle));
        registrar.playToClient(StorageInfoResponsePacket.PACKET_TYPE, StorageInfoResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> StorageInfoResponsePacket.handle(packet)));
        registrar.playToClient(WirelessTransmitterDataPacket.PACKET_TYPE, WirelessTransmitterDataPacket.STREAM_CODEC, ModInitializer.wrapHandler(WirelessTransmitterDataPacket::handle));
        registrar.playToClient(MessagePacket.PACKET_TYPE, MessagePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> MessagePacket.handle(packet)));
        registrar.playToClient(PatternGridAllowedAlternativesUpdatePacket.PACKET_TYPE, PatternGridAllowedAlternativesUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridAllowedAlternativesUpdatePacket::handle));
        registrar.playToClient(AutocrafterNameUpdatePacket.PACKET_TYPE, AutocrafterNameUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocrafterNameUpdatePacket::handle));
        registrar.playToClient(AutocrafterLockedUpdatePacket.PACKET_TYPE, AutocrafterLockedUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocrafterLockedUpdatePacket::handle));
        registrar.playToClient(AutocraftingPreviewResponsePacket.PACKET_TYPE, AutocraftingPreviewResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingPreviewResponsePacket.handle(packet)));
        registrar.playToClient(AutocraftingTreePreviewResponsePacket.PACKET_TYPE, AutocraftingTreePreviewResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingTreePreviewResponsePacket.handle(packet)));
        registrar.playToClient(AutocraftingPreviewCancelResponsePacket.PACKET_TYPE, AutocraftingPreviewCancelResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingPreviewCancelResponsePacket.handle()));
        registrar.playToClient(AutocraftingPreviewMaxAmountResponsePacket.PACKET_TYPE, AutocraftingPreviewMaxAmountResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingPreviewMaxAmountResponsePacket.handle(packet)));
        registrar.playToClient(AutocraftingResponsePacket.PACKET_TYPE, AutocraftingResponsePacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingResponsePacket.handle(packet)));
        registrar.playToClient(AutocraftingMonitorTaskAddedPacket.PACKET_TYPE, AutocraftingMonitorTaskAddedPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingMonitorTaskAddedPacket::handle));
        registrar.playToClient(AutocraftingMonitorTaskRemovedPacket.PACKET_TYPE, AutocraftingMonitorTaskRemovedPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingMonitorTaskRemovedPacket::handle));
        registrar.playToClient(AutocraftingMonitorTaskStatusChangedPacket.PACKET_TYPE, AutocraftingMonitorTaskStatusChangedPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingMonitorTaskStatusChangedPacket::handle));
        registrar.playToClient(AutocraftingMonitorActivePacket.PACKET_TYPE, AutocraftingMonitorActivePacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingMonitorActivePacket::handle));
        registrar.playToClient(AutocraftingTaskCompletedPacket.PACKET_TYPE, AutocraftingTaskCompletedPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingTaskCompletedPacket.handle(packet)));
        registrar.playToClient(ExportingIndicatorUpdatePacket.PACKET_TYPE, ExportingIndicatorUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(ExportingIndicatorUpdatePacket::handle));
    }

    private static void registerClientToServerPackets(PayloadRegistrar registrar) {
        registrar.playToServer(CraftingGridClearPacket.PACKET_TYPE, CraftingGridClearPacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridClearPacket::handle));
        registrar.playToServer(PatternGridClearPacket.PACKET_TYPE, PatternGridClearPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> PatternGridClearPacket.handle(ctx)));
        registrar.playToServer(PatternGridCreatePatternPacket.PACKET_TYPE, PatternGridCreatePatternPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> PatternGridCreatePatternPacket.handle(ctx)));
        registrar.playToServer(CraftingGridRecipeTransferPacket.PACKET_TYPE, CraftingGridRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(CraftingGridRecipeTransferPacket::handle));
        registrar.playToServer(GridExtractPacket.PACKET_TYPE, GridExtractPacket.STREAM_CODEC, ModInitializer.wrapHandler(GridExtractPacket::handle));
        registrar.playToServer(GridInsertPacket.PACKET_TYPE, GridInsertPacket.STREAM_CODEC, ModInitializer.wrapHandler(GridInsertPacket::handle));
        registrar.playToServer(GridScrollPacket.PACKET_TYPE, GridScrollPacket.STREAM_CODEC, ModInitializer.wrapHandler(GridScrollPacket::handle));
        registrar.playToServer(PropertyChangePacket.PACKET_TYPE, PropertyChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(PropertyChangePacket::handle));
        registrar.playToServer(ResourceFilterSlotChangePacket.PACKET_TYPE, ResourceFilterSlotChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(ResourceFilterSlotChangePacket::handle));
        registrar.playToServer(ResourceSlotAmountChangePacket.PACKET_TYPE, ResourceSlotAmountChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(ResourceSlotAmountChangePacket::handle));
        registrar.playToServer(ResourceSlotChangePacket.PACKET_TYPE, ResourceSlotChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(ResourceSlotChangePacket::handle));
        registrar.playToServer(FilterSlotChangePacket.PACKET_TYPE, FilterSlotChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(FilterSlotChangePacket::handle));
        registrar.playToServer(SingleAmountChangePacket.PACKET_TYPE, SingleAmountChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(SingleAmountChangePacket::handle));
        registrar.playToServer(StorageInfoRequestPacket.PACKET_TYPE, StorageInfoRequestPacket.STREAM_CODEC, ModInitializer.wrapHandler(StorageInfoRequestPacket::handle));
        registrar.playToServer(UseSlotReferencedItemPacket.PACKET_TYPE, UseSlotReferencedItemPacket.STREAM_CODEC, ModInitializer.wrapHandler(UseSlotReferencedItemPacket::handle));
        registrar.playToServer(SecurityCardPermissionPacket.PACKET_TYPE, SecurityCardPermissionPacket.STREAM_CODEC, ModInitializer.wrapHandler(SecurityCardPermissionPacket::handle));
        registrar.playToServer(SecurityCardResetPermissionPacket.PACKET_TYPE, SecurityCardResetPermissionPacket.STREAM_CODEC, ModInitializer.wrapHandler(SecurityCardResetPermissionPacket::handle));
        registrar.playToServer(SecurityCardBoundPlayerPacket.PACKET_TYPE, SecurityCardBoundPlayerPacket.STREAM_CODEC, ModInitializer.wrapHandler(SecurityCardBoundPlayerPacket::handle));
        registrar.playToServer(PatternGridAllowedAlternativesChangePacket.PACKET_TYPE, PatternGridAllowedAlternativesChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridAllowedAlternativesChangePacket::handle));
        registrar.playToServer(PatternGridCraftingRecipeTransferPacket.PACKET_TYPE, PatternGridCraftingRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridCraftingRecipeTransferPacket::handle));
        registrar.playToServer(PatternGridProcessingRecipeTransferPacket.PACKET_TYPE, PatternGridProcessingRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridProcessingRecipeTransferPacket::handle));
        registrar.playToServer(PatternGridStonecutterRecipeTransferPacket.PACKET_TYPE, PatternGridStonecutterRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridStonecutterRecipeTransferPacket::handle));
        registrar.playToServer(PatternGridSmithingTableRecipeTransferPacket.PACKET_TYPE, PatternGridSmithingTableRecipeTransferPacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternGridSmithingTableRecipeTransferPacket::handle));
        registrar.playToServer(AutocrafterNameChangePacket.PACKET_TYPE, AutocrafterNameChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocrafterNameChangePacket::handle));
        registrar.playToServer(AutocraftingPreviewRequestPacket.PACKET_TYPE, AutocraftingPreviewRequestPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingPreviewRequestPacket::handle));
        registrar.playToServer(AutocraftingPreviewCancelRequestPacket.PACKET_TYPE, AutocraftingPreviewCancelRequestPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingPreviewCancelRequestPacket.handle(ctx)));
        registrar.playToServer(AutocraftingPreviewMaxAmountRequestPacket.PACKET_TYPE, AutocraftingPreviewMaxAmountRequestPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingPreviewMaxAmountRequestPacket::handle));
        registrar.playToServer(AutocraftingRequestPacket.PACKET_TYPE, AutocraftingRequestPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingRequestPacket::handle));
        registrar.playToServer(AutocraftingMonitorCancelPacket.PACKET_TYPE, AutocraftingMonitorCancelPacket.STREAM_CODEC, ModInitializer.wrapHandler(AutocraftingMonitorCancelPacket::handle));
        registrar.playToServer(AutocraftingMonitorCancelAllPacket.PACKET_TYPE, AutocraftingMonitorCancelAllPacket.STREAM_CODEC, ModInitializer.wrapHandler((packet, ctx) -> AutocraftingMonitorCancelAllPacket.handle(ctx)));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle(packet, () -> ((IPayloadContext)ctx).player());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre e) {
        ServerListener.tick(e.getServer());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent e) {
        ServerListener.starting();
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent e) {
        ServerListener.stopped();
    }

    private static /* synthetic */ IEnergyStorage lambda$registerCapabilities$20(Supplier controllerItem, ItemStack stack, Void ctx) {
        return new EnergyStorageAdapter(((ControllerBlockItem)((Object)controllerItem.get())).createEnergyStorage(stack));
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        @Override
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }
}

