/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeRegistryImpl
implements UpgradeRegistry {
    private final Map<UpgradeDestination, Set<UpgradeMapping>> byDestination = new ConcurrentHashMap<UpgradeDestination, Set<UpgradeMapping>>();
    private final Map<Item, Set<UpgradeMapping>> byUpgradeItem = new ConcurrentHashMap<Item, Set<UpgradeMapping>>();

    @Override
    public UpgradeRegistry.DestinationBuilder forDestination(final UpgradeDestination destination) {
        return new UpgradeRegistry.DestinationBuilder(){

            @Override
            public UpgradeRegistry.DestinationBuilder add(Item upgradeItem, int maxAmount) {
                UpgradeMapping mapping = UpgradeRegistryImpl.createMapping(destination, upgradeItem, maxAmount);
                UpgradeRegistryImpl.this.byDestination.computeIfAbsent(destination, key -> Collections.synchronizedSet(new LinkedHashSet())).add(mapping);
                UpgradeRegistryImpl.this.byUpgradeItem.computeIfAbsent(upgradeItem, key -> Collections.synchronizedSet(new LinkedHashSet())).add(mapping);
                return this;
            }
        };
    }

    private static UpgradeMapping createMapping(UpgradeDestination destination, Item upgradeItem, int maxAmount) {
        ItemStack displayItemStack = new ItemStack((ItemLike)upgradeItem);
        return new UpgradeMapping(destination, upgradeItem, maxAmount, (Component)upgradeItem.getName(displayItemStack).copy().append(" ").append("(").append(String.valueOf(maxAmount)).append(")"), (Component)destination.getName().copy().append(" ").append("(").append(String.valueOf(maxAmount)).append(")"), displayItemStack);
    }

    @Override
    public Set<UpgradeMapping> getByDestination(UpgradeDestination destination) {
        return this.byDestination.getOrDefault(destination, Collections.emptySet());
    }

    @Override
    public Set<UpgradeMapping> getByUpgradeItem(Item upgradeItem) {
        return this.byUpgradeItem.getOrDefault(upgradeItem, Collections.emptySet());
    }
}

