/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeContainerMenu;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeState;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RegulatorUpgradeItem
extends AbstractUpgradeItem {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "regulator_upgrade.help");

    public RegulatorUpgradeItem(UpgradeRegistry registry) {
        super(new Item.Properties(), registry, HELP);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RegulatorUpgradeState initialState = (RegulatorUpgradeState)stack.getOrDefault(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
            Platform.INSTANCE.getMenuOpener().openMenu(serverPlayer, new ExtendedMenuProviderImpl((Component)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME), this.createResourceFilterContainer(stack, initialState), initialState.amount(), newAmount -> this.setAmount(stack, (double)newAmount), RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand)));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private ResourceContainer createResourceFilterContainer(ItemStack stack, RegulatorUpgradeState initialState) {
        ResourceContainer container = ResourceContainerImpl.createForFilter(1);
        container.setListener(() -> {
            RegulatorUpgradeState state = (RegulatorUpgradeState)stack.getOrDefault(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
            PlatformResourceKey resource = container.getResource(0);
            stack.set(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state.withResource(resource));
        });
        initialState.resource().ifPresent(initialResource -> container.set(0, new ResourceAmount((ResourceKey)initialResource, 1L)));
        return container;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new RegulatorTooltipComponent(this.getDestinations(), HELP, this.getConfiguredResource(stack)));
    }

    private void setAmount(ItemStack stack, double amount) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.getOrDefault(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
        stack.set(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state.withAmount(amount));
    }

    public void setAmount(ItemStack regulatorStack, PlatformResourceKey resource, double amount) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)regulatorStack.getOrDefault(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)new RegulatorUpgradeState(amount, Optional.of(resource)));
        regulatorStack.set(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state);
    }

    @Override
    public long getEnergyUsage() {
        return Platform.INSTANCE.getConfig().getUpgrade().getRegulatorUpgradeEnergyUsage();
    }

    @Nullable
    private ResourceAmount getConfiguredResource(ItemStack stack) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.get(DataComponents.INSTANCE.getRegulatorUpgradeState());
        if (state == null) {
            return null;
        }
        return state.resource().map(resource -> {
            double amount = state.amount();
            long normalizedAmount = resource.getResourceType().normalizeAmount(amount);
            if (normalizedAmount <= 0L) {
                return null;
            }
            return new ResourceAmount((ResourceKey)resource, normalizedAmount);
        }).orElse(null);
    }

    public long getDesiredAmount(ItemStack stack, ResourceKey resource) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.getOrDefault(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
        if (state.resource().isEmpty()) {
            return 0L;
        }
        PlatformResourceKey configuredResource = state.resource().get();
        if (!configuredResource.equals(resource)) {
            return 0L;
        }
        double amount = state.amount();
        return configuredResource.getResourceType().normalizeAmount(amount);
    }

    private record ExtendedMenuProviderImpl(@Nullable Component name, ResourceContainer resourceContainer, double amount, Consumer<Double> amountAcceptor, SlotReference slotReference) implements ExtendedMenuProvider<SingleAmountData>
    {
        @Override
        public SingleAmountData getMenuData() {
            return new SingleAmountData(Optional.of(this.slotReference), this.amount, ResourceContainerData.of(this.resourceContainer));
        }

        @Override
        public StreamEncoder<RegistryFriendlyByteBuf, SingleAmountData> getMenuCodec() {
            return SingleAmountData.STREAM_CODEC;
        }

        public Component getDisplayName() {
            return this.name == null ? ContentNames.REGULATOR_UPGRADE : this.name;
        }

        public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
            return new RegulatorUpgradeContainerMenu(syncId, player, this.resourceContainer, this.amountAcceptor, this.slotReference);
        }
    }

    public record RegulatorTooltipComponent(Set<UpgradeMapping> destinations, Component helpText, @Nullable ResourceAmount configuredResource) implements TooltipComponent
    {
    }
}

